/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.docs.Md5Checksum;
import com.google.gdata.data.docs.Publish;
import com.google.gdata.data.docs.PublishAuto;
import com.google.gdata.data.docs.PublishOutsideDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionEntry
extends BaseEntry<RevisionEntry> {
    public static final String PUBLISH_NAMESPACE = "http://schemas.google.com/docs/2007#publish";
    public static final String LABEL = "revision";
    public static final String KIND = "http://schemas.google.com/docs/2007#revision";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/docs/2007#revision", "revision");

    public RevisionEntry() {
        this.getCategories().add(CATEGORY);
    }

    public RevisionEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(RevisionEntry.class, Md5Checksum.class);
        extProfile.declare(RevisionEntry.class, Publish.class);
        extProfile.declare(RevisionEntry.class, PublishAuto.class);
        extProfile.declare(RevisionEntry.class, PublishOutsideDomain.class);
    }

    public String getMd5Checksum() {
        Md5Checksum md5Checksum = this.getExtension(Md5Checksum.class);
        return md5Checksum == null ? null : md5Checksum.getValue();
    }

    public void setMd5Checksum(String md5Checksum) {
        if (md5Checksum == null) {
            this.removeExtension(Md5Checksum.class);
        } else {
            this.setExtension(new Md5Checksum(md5Checksum));
        }
    }

    public void setModifyingUser(Person modifyingUser) {
        this.getAuthors().clear();
        if (modifyingUser != null) {
            this.getAuthors().add(modifyingUser);
        }
    }

    public Person getModifyingUser() {
        if (this.getAuthors().size() > 0) {
            return this.getAuthors().get(0);
        }
        return null;
    }

    public Link getPublishLink() {
        return this.getLink(PUBLISH_NAMESPACE, ILink.Type.HTML);
    }

    public Boolean isPublish() {
        Publish publish = this.getExtension(Publish.class);
        return publish == null ? null : publish.getValue();
    }

    public void setPublish(Boolean publish) {
        if (publish == null) {
            this.removeExtension(Publish.class);
        } else {
            this.setExtension(new Publish(publish));
        }
    }

    public Boolean isPublishAuto() {
        PublishAuto publishAuto = this.getExtension(PublishAuto.class);
        return publishAuto == null ? null : publishAuto.getValue();
    }

    public void setPublishAuto(Boolean publishAuto) {
        if (publishAuto == null) {
            this.removeExtension(PublishAuto.class);
        } else {
            this.setExtension(new PublishAuto(publishAuto));
        }
    }

    public Boolean isPublishOutsideDomain() {
        PublishOutsideDomain publishOutsideDomain = this.getExtension(PublishOutsideDomain.class);
        return publishOutsideDomain == null ? null : publishOutsideDomain.getValue();
    }

    public void setPublishOutsideDomain(Boolean publishOutsideDomain) {
        if (publishOutsideDomain == null) {
            this.removeExtension(PublishOutsideDomain.class);
        } else {
            this.setExtension(new PublishOutsideDomain(publishOutsideDomain));
        }
    }
}

