/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.tasks.VfsTask;
import org.apache.tools.ant.BuildException;

public class ShowFileTask
extends VfsTask {
    private String url;
    private boolean showContent;
    private boolean recursive;
    private static final String INDENT = "  ";

    public void setFile(String string) {
        this.url = string;
    }

    public void setShowContent(boolean bl) {
        this.showContent = bl;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void execute() throws BuildException {
        try {
            FileObject fileObject = this.resolveFile(this.url);
            this.log("Details of " + fileObject.getName().getURI());
            this.showFile(fileObject, INDENT);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void showFile(FileObject fileObject, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(fileObject.getName().getBaseName());
        if (fileObject.exists()) {
            stringBuffer.append(" (");
            stringBuffer.append(fileObject.getType().getName());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(" (unknown)");
        }
        this.log(stringBuffer.toString());
        if (fileObject.exists()) {
            FileObject[] fileObjectArray;
            String string2 = string + INDENT;
            if (fileObject.getType().hasContent()) {
                fileObjectArray = fileObject.getContent();
                this.log(string2 + "Content-Length: " + fileObjectArray.getSize());
                this.log(string2 + "Last-Modified" + new Date(fileObjectArray.getLastModifiedTime()));
                if (this.showContent) {
                    this.log(string2 + "Content:");
                    this.logContent(fileObject, string2);
                }
            }
            if (fileObject.getType().hasChildren()) {
                fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject2 = fileObjectArray[i];
                    if (this.recursive) {
                        this.showFile(fileObject2, string2);
                        continue;
                    }
                    this.log(string2 + fileObject2.getName().getBaseName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logContent(FileObject fileObject, String string) throws Exception {
        InputStream inputStream = fileObject.getContent().getInputStream();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.log(string + string2);
            }
        }
        finally {
            inputStream.close();
        }
    }
}

