/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.zip.ZipFileSystem;

public class ZipFileObject
extends AbstractFileObject
implements FileObject {
    private final HashSet children = new HashSet();
    private final ZipFileSystem fs;
    protected ZipEntry entry;
    private FileType type;

    protected ZipFileObject(FileName fileName, ZipEntry zipEntry, ZipFileSystem zipFileSystem, boolean bl) throws FileSystemException {
        super(fileName, zipFileSystem);
        this.fs = zipFileSystem;
        this.setZipEntry(zipEntry);
        if (!bl) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setZipEntry(ZipEntry zipEntry) {
        if (this.entry != null) {
            return;
        }
        this.type = zipEntry == null || zipEntry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = zipEntry;
    }

    public void attachChild(FileName fileName) {
        this.children.add(fileName.getBaseName());
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    protected FileType doGetType() {
        return this.type;
    }

    protected String[] doListChildren() {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
        }
        return this.fs.getZipFile().getInputStream(this.entry);
    }
}

