/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;

public class SftpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final SftpFileSystemConfigBuilder builder = new SftpFileSystemConfigBuilder();
    private static final String USER_DIR_IS_ROOT = SftpFileSystemConfigBuilder.class.getName() + ".USER_DIR_IS_ROOT";
    private static final String TIMEOUT = SftpFileSystemConfigBuilder.class.getName() + ".TIMEOUT";
    public static final ProxyType PROXY_HTTP = new ProxyType("http");
    public static final ProxyType PROXY_SOCKS5 = new ProxyType("socks");

    public static SftpFileSystemConfigBuilder getInstance() {
        return builder;
    }

    private SftpFileSystemConfigBuilder() {
        super("sftp.");
    }

    public void setUserInfo(FileSystemOptions fileSystemOptions, UserInfo userInfo) {
        this.setParam(fileSystemOptions, UserInfo.class.getName(), userInfo);
    }

    public UserInfo getUserInfo(FileSystemOptions fileSystemOptions) {
        return (UserInfo)this.getParam(fileSystemOptions, UserInfo.class.getName());
    }

    public void setKnownHosts(FileSystemOptions fileSystemOptions, File file) throws FileSystemException {
        this.setParam(fileSystemOptions, "knownHosts", file);
    }

    public File getKnownHosts(FileSystemOptions fileSystemOptions) {
        return (File)this.getParam(fileSystemOptions, "knownHosts");
    }

    public void setIdentities(FileSystemOptions fileSystemOptions, File[] fileArray) throws FileSystemException {
        this.setParam(fileSystemOptions, "identities", fileArray);
    }

    public void setCompression(FileSystemOptions fileSystemOptions, String string) throws FileSystemException {
        this.setParam(fileSystemOptions, "compression", string);
    }

    public String getCompression(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "compression");
    }

    public File[] getIdentities(FileSystemOptions fileSystemOptions) {
        return (File[])this.getParam(fileSystemOptions, "identities");
    }

    public void setStrictHostKeyChecking(FileSystemOptions fileSystemOptions, String string) throws FileSystemException {
        if (string == null || !string.equals("ask") && !string.equals("no") && !string.equals("yes")) {
            throw new FileSystemException("vfs.provider.sftp/StrictHostKeyChecking-arg.error", string);
        }
        this.setParam(fileSystemOptions, "StrictHostKeyChecking", string);
    }

    public String getStrictHostKeyChecking(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "StrictHostKeyChecking");
    }

    public void setUserDirIsRoot(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, USER_DIR_IS_ROOT, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, USER_DIR_IS_ROOT);
    }

    public void setTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, TIMEOUT, n);
    }

    public Integer getTimeout(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, TIMEOUT);
    }

    protected Class getConfigClass() {
        return SftpFileSystem.class;
    }

    public void setProxyHost(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "proxyHost", string);
    }

    public void setProxyPort(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "proxyPort", new Integer(n));
    }

    public String getProxyHost(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, "proxyPort", 0);
    }

    public void setProxyType(FileSystemOptions fileSystemOptions, ProxyType proxyType) {
        this.setParam(fileSystemOptions, "proxyType", proxyType);
    }

    public ProxyType getProxyType(FileSystemOptions fileSystemOptions) {
        return (ProxyType)this.getParam(fileSystemOptions, "proxyType");
    }

    public void setPreferredAuthentications(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "PreferredAuthentications", string);
    }

    public String getPreferredAuthentications(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, "PreferredAuthentications");
    }

    public static class ProxyType
    implements Serializable,
    Comparable {
        private final String proxyType;

        private ProxyType(String string) {
            this.proxyType = string;
        }

        public int compareTo(Object object) {
            return this.proxyType.compareTo(((ProxyType)object).proxyType);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ProxyType proxyType = (ProxyType)object;
            return !(this.proxyType != null ? !this.proxyType.equals(proxyType.proxyType) : proxyType.proxyType != null);
        }
    }
}

