/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.mime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeAttributesMap
implements Map {
    private Log log = LogFactory.getLog(MimeAttributesMap.class);
    private static final String OBJECT_PREFIX = "obj.";
    private final Part part;
    private Map backingMap;
    private final Map mimeMessageGetters = new TreeMap();

    public MimeAttributesMap(Part part) {
        this.part = part;
        this.addMimeMessageMethod(part.getClass().getMethods());
        this.addMimeMessageMethod(part.getClass().getDeclaredMethods());
    }

    private void addMimeMessageMethod(Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length > 0) continue;
            if (method.getName().startsWith("get")) {
                this.mimeMessageGetters.put(method.getName().substring(3), method);
                continue;
            }
            if (!method.getName().startsWith("is")) continue;
            this.mimeMessageGetters.put(method.getName().substring(2), method);
        }
    }

    private Map getMap() {
        if (this.backingMap == null) {
            this.backingMap = this.createMap();
        }
        return this.backingMap;
    }

    private Map createMap() {
        Object object;
        Object messagingException;
        Enumeration enumeration;
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        try {
            enumeration = this.part.getAllHeaders();
        }
        catch (MessagingException messagingException2) {
            throw new RuntimeException(messagingException2);
        }
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            String object32 = header.getName();
            messagingException = treeMap.get(object32);
            if (messagingException == null) {
                treeMap.put(object32, header.getValue());
                continue;
            }
            if (messagingException instanceof String) {
                object = new ArrayList();
                object.add(messagingException);
                object.add(header.getValue());
                treeMap.put(object32, object);
                continue;
            }
            if (!(messagingException instanceof List)) continue;
            ((List)messagingException).add(header.getValue());
        }
        for (Map.Entry entry : this.mimeMessageGetters.entrySet()) {
            messagingException = (String)entry.getKey();
            object = (Method)entry.getValue();
            try {
                Object object2 = ((Method)object).invoke((Object)this.part, null);
                treeMap.put(OBJECT_PREFIX + messagingException, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.debug((Object)illegalAccessException.getLocalizedMessage(), (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.log.debug((Object)invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException);
            }
        }
        if (this.part instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)this.part;
            try {
                messagingException = mimeMessage.getRecipients(MimeMessage.RecipientType.BCC);
                treeMap.put("obj.Recipients.BCC", messagingException);
            }
            catch (MessagingException messagingException3) {
                this.log.debug((Object)messagingException3.getLocalizedMessage(), (Throwable)messagingException3);
            }
            try {
                messagingException = mimeMessage.getRecipients(MimeMessage.RecipientType.CC);
                treeMap.put("obj.Recipients.CC", messagingException);
            }
            catch (MessagingException messagingException4) {
                this.log.debug((Object)messagingException4.getLocalizedMessage(), (Throwable)messagingException4);
            }
            try {
                messagingException = mimeMessage.getRecipients(MimeMessage.RecipientType.TO);
                treeMap.put("obj.Recipients.TO", messagingException);
            }
            catch (MessagingException messagingException5) {
                this.log.debug((Object)messagingException5.getLocalizedMessage(), (Throwable)messagingException5);
            }
            try {
                messagingException = mimeMessage.getRecipients((Message.RecipientType)MimeMessage.RecipientType.NEWSGROUPS);
                treeMap.put("obj.Recipients.NEWSGROUPS", messagingException);
            }
            catch (MessagingException messagingException6) {
                this.log.debug((Object)messagingException6.getLocalizedMessage(), (Throwable)messagingException6);
            }
        }
        return treeMap;
    }

    public int size() {
        return this.getMap().size();
    }

    public boolean isEmpty() {
        return this.getMap().size() < 1;
    }

    public boolean containsKey(Object object) {
        return this.getMap().containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.getMap().containsValue(object);
    }

    public Object get(Object object) {
        return this.getMap().get(object);
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.getMap().keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.getMap().values());
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.getMap().entrySet());
    }
}

