/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.hive.jdbc.HiveDriver;
import org.pentaho.hadoop.hive.jdbc.HadoopConfigurationUtil;

public class ImpalaDriver
extends HiveDriver {
    private static final String METHOD_GET_JDBC_DRIVER = "getJdbcDriver";
    private static final String METHOD_JDBC_PARAM = "hive2";
    private HadoopConfigurationUtil util;

    public ImpalaDriver() {
        this(new HadoopConfigurationUtil());
    }

    public ImpalaDriver(HadoopConfigurationUtil util) {
        if (util == null) {
            throw new NullPointerException();
        }
        this.util = util;
    }

    @Override
    protected Driver getActiveDriver() throws SQLException {
        Driver driver = null;
        try {
            Object shim = this.util.getActiveHadoopShim();
            Method getHiveJdbcDriver = shim.getClass().getMethod(METHOD_GET_JDBC_DRIVER, String.class);
            driver = (Driver)getHiveJdbcDriver.invoke(shim, METHOD_JDBC_PARAM);
        }
        catch (Exception ex) {
            throw new SQLException("Unable to load Impala JDBC driver for the currently active Hadoop configuration", ex);
        }
        if (driver == null || driver.getClass() == this.getClass()) {
            driver = null;
        }
        return driver;
    }

    static {
        try {
            DriverManager.registerDriver(new ImpalaDriver());
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register Impala JDBC driver", ex);
        }
    }
}

