/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.editor.KeyEditor;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;

public abstract class AbstractKeyEditor
extends JComponent
implements KeyEditor {
    public static final String VALID_INPUT_PROPERTY = "validInput";
    private final HierarchicalConfiguration config;
    private final ConfigDescriptionEntry entry;
    private final JLabel stateLabel;
    private final ResourceBundleSupport resources = Messages.getInstance();
    private Icon errorIcon;
    private Icon emptyIcon;
    private boolean validInput;

    protected AbstractKeyEditor(HierarchicalConfiguration config, ConfigDescriptionEntry entry) {
        this.setLayout(new BorderLayout());
        this.config = config;
        this.entry = entry;
        this.stateLabel = new JLabel(this.getEmptyIcon());
    }

    protected Icon getEmptyIcon() {
        if (this.emptyIcon == null) {
            Icon errorIcon = this.getErrorIcon();
            int width = errorIcon.getIconWidth();
            int height = errorIcon.getIconHeight();
            BufferedImage bi = new BufferedImage(width, height, 2);
            this.emptyIcon = new ImageIcon(bi);
        }
        return this.emptyIcon;
    }

    protected Icon getErrorIcon() {
        if (this.errorIcon == null) {
            this.errorIcon = this.resources.getIcon("default-editor.error-icon");
        }
        return this.errorIcon;
    }

    protected void setContentPane(JPanel contentPane) {
        this.removeAll();
        this.add((Component)contentPane, "Center");
        this.add((Component)this.stateLabel, "East");
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ConfigDescriptionEntry getEntry() {
        return this.entry;
    }

    protected String loadValue() {
        return this.config.getConfigProperty(this.entry.getKeyName());
    }

    protected void storeValue(String o) {
        this.config.setConfigProperty(this.entry.getKeyName(), o);
    }

    protected void deleteValue() {
        this.config.setConfigProperty(this.entry.getKeyName(), null);
    }

    public boolean isValidInput() {
        return this.validInput;
    }

    protected void setValidInput(boolean validInput) {
        if (this.validInput != validInput) {
            boolean oldValue = this.validInput;
            this.validInput = validInput;
            this.firePropertyChange(VALID_INPUT_PROPERTY, oldValue, validInput);
            if (!this.validInput) {
                this.stateLabel.setIcon(this.getErrorIcon());
            } else {
                this.stateLabel.setIcon(this.getEmptyIcon());
            }
        }
    }

    @Override
    public boolean isDefined() {
        return this.config.isLocallyDefined(this.entry.getKeyName());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

