/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.io.CodecMap;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.JobBase;
import com.cloudera.sqoop.orm.TableClassName;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.apache.sqoop.util.PerfCounters;
import org.apache.sqoop.validation.ValidationContext;
import org.apache.sqoop.validation.ValidationException;

public class ImportJobBase
extends JobBase {
    private ImportJobContext context;
    public static final Log LOG = LogFactory.getLog((String)ImportJobBase.class.getName());
    public static final String PROPERTY_BIGDECIMAL_FORMAT = "sqoop.bigdecimal.format.string";
    public static final boolean PROPERTY_BIGDECIMAL_FORMAT_DEFAULT = true;

    public ImportJobBase() {
        this(null);
    }

    public ImportJobBase(SqoopOptions opts) {
        this(opts, null, null, null, null);
    }

    public ImportJobBase(SqoopOptions opts, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass, ImportJobContext context) {
        super(opts, mapperClass, inputFormatClass, outputFormatClass);
        this.context = context;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setOutputFormatClass(this.getOutputFormatClass());
        if (this.isHCatJob) {
            LOG.debug((Object)"Configuring output format for HCatalog  import job");
            SqoopHCatUtilities.configureImportOutputFormat(this.options, job, this.getContext().getConnManager(), tableName, job.getConfiguration());
            return;
        }
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            job.getConfiguration().set("mapred.output.value.class", tableClassName);
        }
        if (this.options.shouldUseCompression()) {
            Class codecClass;
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            String codecName = this.options.getCompressionCodec();
            if (codecName == null) {
                codecClass = GzipCodec.class;
            } else {
                Configuration conf = job.getConfiguration();
                codecClass = CodecMap.getCodec(codecName, conf).getClass();
            }
            FileOutputFormat.setOutputCompressorClass((Job)job, codecClass);
            if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
                SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            }
            if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
                if (codecName != null) {
                    String shortName = CodecMap.getCodecShortNameByName(codecName, job.getConfiguration());
                    if (shortName.equalsIgnoreCase("default")) {
                        shortName = "deflate";
                    }
                    job.getConfiguration().set("avro.output.codec", shortName);
                } else {
                    job.getConfiguration().set("avro.output.codec", "deflate");
                }
            }
        }
        Path outputPath = this.context.getDestination();
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
    }

    @Override
    protected boolean runJob(Job job) throws ClassNotFoundException, IOException, InterruptedException {
        PerfCounters perfCounters = new PerfCounters();
        perfCounters.startClock();
        boolean success = this.doSubmitJob(job);
        if (this.isHCatJob) {
            SqoopHCatUtilities.instance().invokeOutputCommitterForLocalMode(job);
        }
        perfCounters.stopClock();
        Counters jobCounters = job.getCounters();
        if (null == jobCounters) {
            this.displayRetiredJobNotice(LOG);
        } else {
            perfCounters.addBytes(jobCounters.getGroup("FileSystemCounters").findCounter("HDFS_BYTES_WRITTEN").getValue());
            LOG.info((Object)("Transferred " + perfCounters.toString()));
            long numRecords = ConfigurationHelper.getNumMapOutputRecords(job);
            LOG.info((Object)("Retrieved " + numRecords + " records."));
        }
        return success;
    }

    protected boolean doSubmitJob(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        return job.waitForCompletion(true);
    }

    public void runImport(String tableName, String ormJarFile, String splitByCol, Configuration conf) throws IOException, ImportException {
        if (this.isHCatJob && this.options.isDirect() && !this.context.getConnManager().isDirectModeHCatSupported()) {
            throw new IOException("Direct import is not compatible with HCatalog operations using the connection manager " + this.context.getConnManager().getClass().getName() + ". Please remove the parameter --direct");
        }
        if (null != tableName) {
            LOG.info((Object)("Beginning import of " + tableName));
        } else {
            LOG.info((Object)"Beginning query import.");
        }
        String tableClassName = null;
        if (!this.getContext().getConnManager().isORMFacilitySelfManaged()) {
            tableClassName = new TableClassName(this.options).getClassForTable(tableName);
        }
        this.loadJars(conf, ormJarFile, tableClassName);
        Job job = this.createJob(conf);
        try {
            job.getConfiguration().set("mapred.jar", ormJarFile);
            if (this.options.getMapreduceJobName() != null) {
                job.setJobName(this.options.getMapreduceJobName());
            }
            this.propagateOptionsToJob(job);
            this.configureInputFormat(job, tableName, tableClassName, splitByCol);
            this.configureOutputFormat(job, tableName, tableClassName);
            this.configureMapper(job, tableName, tableClassName);
            this.configureNumTasks(job);
            this.cacheJars(job, this.getContext().getConnManager());
            this.jobSetup(job);
            this.setJob(job);
            boolean success = this.runJob(job);
            if (!success) {
                throw new ImportException("Import job failed!");
            }
            this.completeImport(job);
            if (this.options.isValidationEnabled()) {
                this.validateImport(tableName, conf, job);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            this.unloadJars();
            this.jobTeardown(job);
        }
    }

    protected void completeImport(Job job) throws IOException, ImportException {
    }

    protected void validateImport(String tableName, Configuration conf, Job job) throws ImportException {
        LOG.debug((Object)"Validating imported data.");
        try {
            ValidationContext validationContext = new ValidationContext(this.getRowCountFromDB(this.context.getConnManager(), tableName), this.getRowCountFromHadoop(job));
            this.doValidate(this.options, conf, validationContext);
        }
        catch (ValidationException e) {
            throw new ImportException("Error validating row counts", e);
        }
        catch (SQLException e) {
            throw new ImportException("Error retrieving DB source row count", e);
        }
        catch (IOException e) {
            throw new ImportException("Error retrieving target row count", e);
        }
        catch (InterruptedException e) {
            throw new ImportException("Error retrieving target row count", e);
        }
    }

    protected void jobSetup(Job job) throws IOException, ImportException {
    }

    protected void jobTeardown(Job job) throws IOException, ImportException {
    }

    protected ImportJobContext getContext() {
        return this.context;
    }
}

