/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import java.util.ArrayList;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.concept.types.fieldtype.FieldTypeSettings;

public class PhysicalColumn
extends ConceptUtilityBase
implements ConceptUtilityInterface,
Cloneable {
    private PhysicalTable physicalTable;

    public PhysicalColumn(String id, String formula, FieldTypeSettings fieldType, AggregationSettings aggregationType, PhysicalTable tableinfo) {
        super(id);
        this.setFormula(formula);
        this.setFieldType(fieldType);
        this.setAggregationType(aggregationType);
        this.setAggregationList(new ArrayList<AggregationSettings>());
        this.setDataType(DataTypeSettings.UNKNOWN);
        this.physicalTable = tableinfo;
    }

    public PhysicalColumn(String id) {
        this(id, null, FieldTypeSettings.OTHER, AggregationSettings.NONE, null);
    }

    public PhysicalColumn() {
        this(null);
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("PhysicalColumn.USER_DESCRIPTION");
    }

    protected Object clone() {
        try {
            PhysicalColumn retval = (PhysicalColumn)super.clone();
            retval.setConcept((ConceptInterface)this.getConcept().clone());
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setTable(PhysicalTable tableinfo) {
        this.physicalTable = tableinfo;
    }

    public PhysicalTable getTable() {
        return this.physicalTable;
    }

    public String getTableColumn() {
        String retval;
        if (this.getFormula() != null && this.getFormula().length() > 0) {
            retval = this.getFormula();
            if (retval == null || retval.length() == 0) {
                retval = this.getId();
            }
        } else {
            PhysicalTable table = this.getTable();
            retval = table.getId() + "." + this.getId();
        }
        return retval;
    }

    public String getAliasColumn(String tableAlias, String formula) {
        DatabaseMeta databaseMeta = this.getTable().getDatabaseMeta();
        return this.getAliasColumn(tableAlias, formula, databaseMeta);
    }

    public String getAliasColumn(String tableAlias, String formula, DatabaseMeta databaseMeta) {
        String retval = this.getTable() != null && formula != null ? (!this.isExact() ? databaseMeta.quoteField(tableAlias) + "." + databaseMeta.quoteField(formula) : this.getFormula()) : "??";
        return retval;
    }

    public String getRenameAsColumn(DatabaseMeta dbinfo, int columnNr) {
        String retval = "";
        retval = this.hasAggregate() && !this.isExact() ? retval + "F___" + columnNr : (this.isExact() ? retval + "E___" + columnNr : retval + this.getFormula());
        return retval;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PhysicalColumn)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PhysicalColumn rhs = (PhysicalColumn)obj;
        String lhsFormula = null != this.getFormula() ? this.getFormula().toUpperCase() : null;
        String rhsFormula = null != rhs.getFormula() ? rhs.getFormula().toUpperCase() : null;
        return new EqualsBuilder().appendSuper(super.equals(rhs)).append((Object)lhsFormula, (Object)rhsFormula).append((Object)this.getAggregationType(), (Object)rhs.getAggregationType()).append((Object)this.getFieldType(), (Object)rhs.getFieldType()).append((Object)this.physicalTable, (Object)rhs.physicalTable).append(this.getAggregationList(), rhs.getAggregationList()).isEquals();
    }

    @Override
    public int hashCode() {
        String formulaToHash = null != this.getFormula() ? this.getFormula().toUpperCase() : null;
        return new HashCodeBuilder(17, 199).appendSuper(super.hashCode()).append((Object)formulaToHash).append((Object)this.getAggregationType()).append((Object)this.getFieldType()).append((Object)this.physicalTable).toHashCode();
    }

    @Override
    public String toString() {
        return this.getId() == null ? "NULL" : this.getId();
    }

    public void setAggregationType(String aggregationTypeDesc) {
        this.setAggregationType(AggregationSettings.getType(aggregationTypeDesc));
        this.setChanged();
    }

    public void setFieldType(String fieldTypeDescription) {
        this.setFieldType(FieldTypeSettings.getType(fieldTypeDescription));
        this.setChanged();
    }
}

