/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.ConnectionStatus;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.util.annotations.Immutable;
import org.bson.util.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ReplicaSetStatus
extends ConnectionStatus {
    static final Logger _rootLogger = Logger.getLogger("com.mongodb.ReplicaSetStatus");
    final ReplicaSetHolder _replicaSetHolder = new ReplicaSetHolder();
    private final AtomicReference<Logger> _logger = new AtomicReference<Logger>(_rootLogger);
    private final AtomicReference<String> _lastPrimarySignal = new AtomicReference();
    static final int slaveAcceptableLatencyMS = Integer.parseInt(System.getProperty("com.mongodb.slaveAcceptableLatencyMS", "15"));
    static final int inetAddrCacheMS = Integer.parseInt(System.getProperty("com.mongodb.inetAddrCacheMS", "300000"));

    ReplicaSetStatus(Mongo mongo, List<ServerAddress> initial) {
        super(initial, mongo);
        this._updater = new Updater(initial);
    }

    public String getName() {
        return this._replicaSetHolder.get().getSetName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{replSetName: ").append(this._replicaSetHolder.get().getSetName());
        sb.append(", members: ").append(this._replicaSetHolder);
        sb.append(", updaterIntervalMS: ").append(updaterIntervalMS);
        sb.append(", updaterIntervalNoMasterMS: ").append(updaterIntervalNoMasterMS);
        sb.append(", slaveAcceptableLatencyMS: ").append(slaveAcceptableLatencyMS);
        sb.append(", inetAddrCacheMS: ").append(inetAddrCacheMS);
        sb.append(", latencySmoothFactor: ").append(latencySmoothFactor);
        sb.append("}");
        return sb.toString();
    }

    public ServerAddress getMaster() {
        ReplicaSetNode n = this.getMasterNode();
        if (n == null) {
            return null;
        }
        return n.getServerAddress();
    }

    ReplicaSetNode getMasterNode() {
        this.checkClosed();
        return this._replicaSetHolder.get().getMaster();
    }

    public boolean isMaster(ServerAddress srv) {
        if (srv == null) {
            return false;
        }
        return srv.equals(this.getMaster());
    }

    ServerAddress getASecondary() {
        ReplicaSetNode node = this._replicaSetHolder.get().getASecondary();
        if (node == null) {
            return null;
        }
        return node._addr;
    }

    @Override
    boolean hasServerUp() {
        for (ReplicaSetNode node : this._replicaSetHolder.get().getAll()) {
            if (!node.isOk()) continue;
            return true;
        }
        return false;
    }

    @Override
    ConnectionStatus.Node ensureMaster() {
        ReplicaSetNode masterNode = this.getMasterNode();
        if (masterNode != null) {
            return masterNode;
        }
        this._replicaSetHolder.waitForNextUpdate();
        masterNode = this.getMasterNode();
        if (masterNode != null) {
            return masterNode;
        }
        return null;
    }

    @Override
    List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        for (ReplicaSetNode node : this._replicaSetHolder.get().getAll()) {
            addrs.add(node.getServerAddress());
        }
        return addrs;
    }

    public int getMaxBsonObjectSize() {
        return this._replicaSetHolder.get().getMaxBsonObjectSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Updater
    extends ConnectionStatus.BackgroundUpdater {
        private final List<UpdatableReplicaSetNode> _all;
        private volatile long _nextResolveTime;
        private final Random _random;

        Updater(List<ServerAddress> initial) {
            super("ReplicaSetStatus:Updater");
            this._random = new Random();
            this._all = new ArrayList<UpdatableReplicaSetNode>(initial.size());
            for (ServerAddress addr : initial) {
                this._all.add(new UpdatableReplicaSetNode(addr, this._all, ReplicaSetStatus.this._logger, ReplicaSetStatus.this._mongo, ReplicaSetStatus.this._mongoOptions, ReplicaSetStatus.this._lastPrimarySignal));
            }
            this._nextResolveTime = System.currentTimeMillis() + (long)inetAddrCacheMS;
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    int curUpdateIntervalMS = ConnectionStatus.updaterIntervalNoMasterMS;
                    try {
                        this.updateAll();
                        this.updateInetAddresses();
                        ReplicaSet replicaSet = new ReplicaSet(this.createNodeList(), this._random, slaveAcceptableLatencyMS);
                        ReplicaSetStatus.this._replicaSetHolder.set(replicaSet);
                        if (replicaSet.getErrorStatus().isOk() && replicaSet.hasMaster()) {
                            ReplicaSetStatus.this._mongo.getConnector().setMaster(replicaSet.getMaster());
                            curUpdateIntervalMS = ConnectionStatus.updaterIntervalMS;
                        }
                    }
                    catch (Exception e) {
                        ((Logger)ReplicaSetStatus.this._logger.get()).log(Level.WARNING, "couldn't do update pass", e);
                    }
                    Thread.sleep(curUpdateIntervalMS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ReplicaSetStatus.this._replicaSetHolder.close();
            this.closeAllNodes();
        }

        public synchronized void updateAll() {
            HashSet<UpdatableReplicaSetNode> seenNodes = new HashSet<UpdatableReplicaSetNode>();
            for (int i = 0; i < this._all.size(); ++i) {
                this._all.get(i).update(seenNodes);
            }
            if (seenNodes.size() > 0) {
                Iterator<UpdatableReplicaSetNode> it = this._all.iterator();
                while (it.hasNext()) {
                    if (seenNodes.contains(it.next())) continue;
                    it.remove();
                }
            }
        }

        private List<ReplicaSetNode> createNodeList() {
            ArrayList<ReplicaSetNode> nodeList = new ArrayList<ReplicaSetNode>(this._all.size());
            for (UpdatableReplicaSetNode cur : this._all) {
                nodeList.add(new ReplicaSetNode(cur._addr, cur._names, cur._setName, cur._pingTimeMS, cur._ok, cur._isMaster, cur._isSecondary, cur._tags, cur._maxBsonObjectSize));
            }
            return nodeList;
        }

        private void updateInetAddresses() {
            long now = System.currentTimeMillis();
            if (inetAddrCacheMS > 0 && this._nextResolveTime < now) {
                this._nextResolveTime = now + (long)inetAddrCacheMS;
                for (UpdatableReplicaSetNode node : this._all) {
                    node.updateAddr();
                }
            }
        }

        private void closeAllNodes() {
            for (UpdatableReplicaSetNode node : this._all) {
                try {
                    node.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpdatableReplicaSetNode
    extends ConnectionStatus.UpdatableNode {
        private final Set<String> _names = Collections.synchronizedSet(new HashSet());
        final LinkedHashMap<String, String> _tags = new LinkedHashMap();
        boolean _isMaster = false;
        boolean _isSecondary = false;
        String _setName;
        private final AtomicReference<Logger> _logger;
        private final AtomicReference<String> _lastPrimarySignal;
        private final List<UpdatableReplicaSetNode> _all;

        UpdatableReplicaSetNode(ServerAddress addr, List<UpdatableReplicaSetNode> all, AtomicReference<Logger> logger, Mongo mongo, MongoOptions mongoOptions, AtomicReference<String> lastPrimarySignal) {
            super(addr, mongo, mongoOptions);
            this._all = all;
            this._names.add(addr.toString());
            this._logger = logger;
            this._lastPrimarySignal = lastPrimarySignal;
        }

        private void updateAddr() {
            try {
                if (this._addr.updateInetAddress()) {
                    this._port = new DBPort(this._addr, null, this._mongoOptions);
                    this._mongo.getConnector().updatePortPool(this._addr);
                    this._logger.get().log(Level.INFO, "Address of host " + this._addr.toString() + " changed to " + this._addr.getSocketAddress().toString());
                }
            }
            catch (UnknownHostException ex) {
                this._logger.get().log(Level.WARNING, null, ex);
            }
        }

        void update(Set<UpdatableReplicaSetNode> seenNodes) {
            UpdatableReplicaSetNode node;
            String host;
            CommandResult res = this.update();
            if (res == null || !this._ok) {
                return;
            }
            this._isMaster = res.getBoolean("ismaster", false);
            this._isSecondary = res.getBoolean("secondary", false);
            this._lastPrimarySignal.set(res.getString("primary"));
            if (res.containsField("hosts")) {
                for (Object x : (List)res.get("hosts")) {
                    host = x.toString();
                    node = this._addIfNotHere(host);
                    if (node == null || seenNodes == null) continue;
                    seenNodes.add(node);
                }
            }
            if (res.containsField("passives")) {
                for (Object x : (List)res.get("passives")) {
                    host = x.toString();
                    node = this._addIfNotHere(host);
                    if (node == null || seenNodes == null) continue;
                    seenNodes.add(node);
                }
            }
            if (res.containsField("tags")) {
                DBObject tags = (DBObject)res.get("tags");
                for (String key : tags.keySet()) {
                    this._tags.put(key, tags.get(key).toString());
                }
            }
            if (res.containsField("setName")) {
                this._setName = res.getString("setName", "");
                if (this._logger.get() == null) {
                    this._logger.set(Logger.getLogger(_rootLogger.getName() + "." + this._setName));
                }
            }
        }

        @Override
        protected Logger getLogger() {
            return this._logger.get();
        }

        UpdatableReplicaSetNode _addIfNotHere(String host) {
            UpdatableReplicaSetNode n = this.findNode(host, this._all, this._logger);
            if (n == null) {
                try {
                    n = new UpdatableReplicaSetNode(new ServerAddress(host), this._all, this._logger, this._mongo, this._mongoOptions, this._lastPrimarySignal);
                    this._all.add(n);
                }
                catch (UnknownHostException un) {
                    this._logger.get().log(Level.WARNING, "couldn't resolve host [" + host + "]");
                }
            }
            return n;
        }

        private UpdatableReplicaSetNode findNode(String host, List<UpdatableReplicaSetNode> members, AtomicReference<Logger> logger) {
            ServerAddress addr;
            for (UpdatableReplicaSetNode node : members) {
                if (!node._names.contains(host)) continue;
                return node;
            }
            try {
                addr = new ServerAddress(host);
            }
            catch (UnknownHostException un) {
                logger.get().log(Level.WARNING, "couldn't resolve host [" + host + "]");
                return null;
            }
            for (UpdatableReplicaSetNode node : members) {
                if (!node._addr.equals(addr)) continue;
                node._names.add(host);
                return node;
            }
            return null;
        }

        public void close() {
            this._port.close();
            this._port = null;
        }
    }

    @Immutable
    static final class Tag {
        final String key;
        final String value;

        Tag(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            if (this.key != null ? !this.key.equals(tag.key) : tag.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(tag.value) : tag.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public DBObject toDBObject() {
            return new BasicDBObject(this.key, this.value);
        }
    }

    @Immutable
    static final class ReplicaSetErrorStatus {
        final boolean ok;
        final String error;

        ReplicaSetErrorStatus(boolean ok, String error) {
            this.ok = ok;
            this.error = error;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getError() {
            return this.error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static class ReplicaSetNode
    extends ConnectionStatus.Node {
        private final Set<String> _names;
        private final Set<Tag> _tags;
        private final boolean _isMaster;
        private final boolean _isSecondary;
        private final String _setName;

        ReplicaSetNode(ServerAddress addr, Set<String> names, String setName, float pingTime, boolean ok, boolean isMaster, boolean isSecondary, LinkedHashMap<String, String> tags, int maxBsonObjectSize) {
            super(pingTime, addr, maxBsonObjectSize, ok);
            this._names = Collections.unmodifiableSet(new HashSet<String>(names));
            this._setName = setName;
            this._isMaster = isMaster;
            this._isSecondary = isSecondary;
            this._tags = Collections.unmodifiableSet(ReplicaSetNode.getTagsFromMap(tags));
        }

        private static Set<Tag> getTagsFromMap(LinkedHashMap<String, String> tagMap) {
            HashSet<Tag> tagSet = new HashSet<Tag>();
            for (Map.Entry<String, String> curEntry : tagMap.entrySet()) {
                tagSet.add(new Tag(curEntry.getKey(), curEntry.getValue()));
            }
            return tagSet;
        }

        public boolean master() {
            return this._ok && this._isMaster;
        }

        public boolean secondary() {
            return this._ok && this._isSecondary;
        }

        public Set<String> getNames() {
            return this._names;
        }

        public String getSetName() {
            return this._setName;
        }

        public Set<Tag> getTags() {
            return this._tags;
        }

        public float getPingTime() {
            return this._pingTime;
        }

        @Override
        public String toJSON() {
            StringBuilder buf = new StringBuilder();
            buf.append("{ address:'").append(this._addr).append("', ");
            buf.append("ok:").append(this._ok).append(", ");
            buf.append("ping:").append(this._pingTime).append(", ");
            buf.append("isMaster:").append(this._isMaster).append(", ");
            buf.append("isSecondary:").append(this._isSecondary).append(", ");
            buf.append("setName:").append(this._setName).append(", ");
            buf.append("maxBsonObjectSize:").append(this._maxBsonObjectSize).append(", ");
            if (this._tags != null && this._tags.size() > 0) {
                ArrayList<DBObject> tagObjects = new ArrayList<DBObject>();
                for (Tag tag : this._tags) {
                    tagObjects.add(tag.toDBObject());
                }
                buf.append(new BasicDBObject("tags", tagObjects));
            }
            buf.append("}");
            return buf.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaSetNode node = (ReplicaSetNode)o;
            if (this._isMaster != node._isMaster) {
                return false;
            }
            if (this._maxBsonObjectSize != node._maxBsonObjectSize) {
                return false;
            }
            if (this._isSecondary != node._isSecondary) {
                return false;
            }
            if (this._ok != node._ok) {
                return false;
            }
            if (Float.compare(node._pingTime, this._pingTime) != 0) {
                return false;
            }
            if (!this._addr.equals(node._addr)) {
                return false;
            }
            if (!((Object)this._names).equals(node._names)) {
                return false;
            }
            if (!((Object)this._tags).equals(node._tags)) {
                return false;
            }
            return this._setName.equals(node._setName);
        }

        @Override
        public int hashCode() {
            int result = this._addr.hashCode();
            result = 31 * result + (this._pingTime != 0.0f ? Float.floatToIntBits(this._pingTime) : 0);
            result = 31 * result + ((Object)this._names).hashCode();
            result = 31 * result + ((Object)this._tags).hashCode();
            result = 31 * result + (this._ok ? 1 : 0);
            result = 31 * result + (this._isMaster ? 1 : 0);
            result = 31 * result + (this._isSecondary ? 1 : 0);
            result = 31 * result + this._setName.hashCode();
            result = 31 * result + this._maxBsonObjectSize;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static class ReplicaSet {
        final List<ReplicaSetNode> all;
        final Random random;
        final List<ReplicaSetNode> acceptableSecondaries;
        final List<ReplicaSetNode> acceptableMembers;
        final ReplicaSetNode master;
        final String setName;
        final ReplicaSetErrorStatus errorStatus;
        private int acceptableLatencyMS;

        public ReplicaSet(List<ReplicaSetNode> nodeList, Random random, int acceptableLatencyMS) {
            this.random = random;
            this.all = Collections.unmodifiableList(new ArrayList<ReplicaSetNode>(nodeList));
            this.acceptableLatencyMS = acceptableLatencyMS;
            this.errorStatus = this.validate();
            this.setName = this.determineSetName();
            this.acceptableSecondaries = Collections.unmodifiableList(ReplicaSet.calculateGoodMembers(this.all, ReplicaSet.calculateBestPingTime(this.all, false), acceptableLatencyMS, false));
            this.acceptableMembers = Collections.unmodifiableList(ReplicaSet.calculateGoodMembers(this.all, ReplicaSet.calculateBestPingTime(this.all, true), acceptableLatencyMS, true));
            this.master = this.findMaster();
        }

        public List<ReplicaSetNode> getAll() {
            this.checkStatus();
            return this.all;
        }

        public boolean hasMaster() {
            return this.getMaster() != null;
        }

        public ReplicaSetNode getMaster() {
            this.checkStatus();
            return this.master;
        }

        public int getMaxBsonObjectSize() {
            if (this.hasMaster()) {
                return this.getMaster().getMaxBsonObjectSize();
            }
            return 0x400000;
        }

        public ReplicaSetNode getASecondary() {
            this.checkStatus();
            if (this.acceptableSecondaries.isEmpty()) {
                return null;
            }
            return this.acceptableSecondaries.get(this.random.nextInt(this.acceptableSecondaries.size()));
        }

        public ReplicaSetNode getASecondary(List<Tag> tags) {
            this.checkStatus();
            if (tags.isEmpty()) {
                return this.getASecondary();
            }
            List<ReplicaSetNode> acceptableTaggedSecondaries = this.getGoodSecondariesByTags(tags);
            if (acceptableTaggedSecondaries.isEmpty()) {
                return null;
            }
            return acceptableTaggedSecondaries.get(this.random.nextInt(acceptableTaggedSecondaries.size()));
        }

        public ReplicaSetNode getAMember() {
            this.checkStatus();
            if (this.acceptableMembers.isEmpty()) {
                return null;
            }
            return this.acceptableMembers.get(this.random.nextInt(this.acceptableMembers.size()));
        }

        public ReplicaSetNode getAMember(List<Tag> tags) {
            this.checkStatus();
            if (tags.isEmpty()) {
                return this.getAMember();
            }
            List<ReplicaSetNode> acceptableTaggedMembers = this.getGoodMembersByTags(tags);
            if (acceptableTaggedMembers.isEmpty()) {
                return null;
            }
            return acceptableTaggedMembers.get(this.random.nextInt(acceptableTaggedMembers.size()));
        }

        List<ReplicaSetNode> getGoodSecondaries(List<ReplicaSetNode> all) {
            ArrayList<ReplicaSetNode> goodSecondaries = new ArrayList<ReplicaSetNode>(all.size());
            for (ReplicaSetNode cur : all) {
                if (!cur.isOk()) continue;
                goodSecondaries.add(cur);
            }
            return goodSecondaries;
        }

        public List<ReplicaSetNode> getGoodSecondariesByTags(List<Tag> tags) {
            this.checkStatus();
            List<ReplicaSetNode> taggedSecondaries = ReplicaSet.getMembersByTags(this.all, tags);
            return ReplicaSet.calculateGoodMembers(taggedSecondaries, ReplicaSet.calculateBestPingTime(taggedSecondaries, false), this.acceptableLatencyMS, false);
        }

        public List<ReplicaSetNode> getGoodMembersByTags(List<Tag> tags) {
            this.checkStatus();
            List<ReplicaSetNode> taggedMembers = ReplicaSet.getMembersByTags(this.all, tags);
            return ReplicaSet.calculateGoodMembers(taggedMembers, ReplicaSet.calculateBestPingTime(taggedMembers, true), this.acceptableLatencyMS, true);
        }

        public String getSetName() {
            this.checkStatus();
            return this.setName;
        }

        public ReplicaSetErrorStatus getErrorStatus() {
            return this.errorStatus;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (ReplicaSetNode node : this.getAll()) {
                sb.append(node.toJSON()).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(" ]");
            return sb.toString();
        }

        private void checkStatus() {
            if (!this.errorStatus.isOk()) {
                throw new MongoException(this.errorStatus.getError());
            }
        }

        private ReplicaSetNode findMaster() {
            for (ReplicaSetNode node : this.all) {
                if (!node.master()) continue;
                return node;
            }
            return null;
        }

        private String determineSetName() {
            for (ReplicaSetNode node : this.all) {
                String nodeSetName = node.getSetName();
                if (nodeSetName == null || nodeSetName.equals("")) continue;
                return nodeSetName;
            }
            return null;
        }

        private ReplicaSetErrorStatus validate() {
            HashSet<String> nodeNames = new HashSet<String>();
            for (ReplicaSetNode node : this.all) {
                String nodeSetName = node.getSetName();
                if (nodeSetName == null || nodeSetName.equals("")) continue;
                nodeNames.add(nodeSetName);
            }
            if (nodeNames.size() <= 1) {
                return new ReplicaSetErrorStatus(true, null);
            }
            return new ReplicaSetErrorStatus(false, "nodes with different set names detected: " + nodeNames.toString());
        }

        static float calculateBestPingTime(List<ReplicaSetNode> members, boolean includeMaster) {
            float bestPingTime = Float.MAX_VALUE;
            for (ReplicaSetNode cur : members) {
                if (!cur.secondary() && (!includeMaster || !cur.master()) || !(cur._pingTime < bestPingTime)) continue;
                bestPingTime = cur._pingTime;
            }
            return bestPingTime;
        }

        static List<ReplicaSetNode> calculateGoodMembers(List<ReplicaSetNode> members, float bestPingTime, int acceptableLatencyMS, boolean includeMaster) {
            ArrayList<ReplicaSetNode> goodSecondaries = new ArrayList<ReplicaSetNode>(members.size());
            for (ReplicaSetNode cur : members) {
                if (!cur.secondary() && (!includeMaster || !cur.master()) || !(cur._pingTime - (float)acceptableLatencyMS <= bestPingTime)) continue;
                goodSecondaries.add(cur);
            }
            return goodSecondaries;
        }

        static List<ReplicaSetNode> getMembersByTags(List<ReplicaSetNode> members, List<Tag> tags) {
            ArrayList<ReplicaSetNode> membersByTag = new ArrayList<ReplicaSetNode>();
            for (ReplicaSetNode cur : members) {
                if (tags == null || cur.getTags() == null || !cur.getTags().containsAll(tags)) continue;
                membersByTag.add(cur);
            }
            return membersByTag;
        }
    }

    @ThreadSafe
    class ReplicaSetHolder {
        private volatile ReplicaSet members;

        ReplicaSetHolder() {
        }

        synchronized ReplicaSet get() {
            while (this.members == null) {
                try {
                    this.wait(ReplicaSetStatus.this._mongo.getMongoOptions().getConnectTimeout());
                }
                catch (InterruptedException e) {
                    throw new MongoInterruptedException("Interrupted while waiting for next update to replica set status", e);
                }
            }
            return this.members;
        }

        synchronized void set(ReplicaSet members) {
            if (members == null) {
                throw new IllegalArgumentException("members can not be null");
            }
            this.members = members;
            this.notifyAll();
        }

        synchronized void waitForNextUpdate() {
            try {
                this.wait(ReplicaSetStatus.this._mongo.getMongoOptions().getConnectTimeout());
            }
            catch (InterruptedException e) {
                throw new MongoInterruptedException("Interrupted while waiting for next update to replica set status", e);
            }
        }

        public synchronized void close() {
            this.members = null;
            this.notifyAll();
        }

        public String toString() {
            ReplicaSet cur = this.members;
            if (cur != null) {
                return cur.toString();
            }
            return "none";
        }
    }
}

