/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public abstract class TypedOutputEvalFunc<OUT>
extends EvalFunc<OUT> {
    protected Class<OUT> outTypeClass = TypedOutputEvalFunc.getTypeArguments(TypedOutputEvalFunc.class, this.getClass()).get(0);

    public Class<OUT> getOutputTypeClass() {
        return this.outTypeClass;
    }

    protected void verifyInput(Tuple input, int minimumSize) throws IOException {
        TypedOutputEvalFunc.verifyUdfInput(this.getCounterGroup(), input, minimumSize);
    }

    protected String getCounterGroup() {
        return this.getClass().getName();
    }

    protected static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = Maps.newHashMap();
        Type type = childClass;
        while (!TypedOutputEvalFunc.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(TypedOutputEvalFunc.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypedOutputEvalFunc.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = TypedOutputEvalFunc.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    protected static void verifyUdfInput(String klass, Tuple input, int minimumSize) throws IOException {
        if (input == null) {
            TypedOutputEvalFunc.safeIncrCounter(klass, "NullInput", 1L);
            throw new IOException("Null input to UDF " + klass);
        }
        if (input.size() < minimumSize) {
            String reason = "TooFewArguments_Got_" + input.size() + "_NeededAtLeast_" + minimumSize;
            TypedOutputEvalFunc.safeIncrCounter(klass, reason, 1L);
            throw new IOException("Not enough arguments to " + klass + ": got " + input.size() + ", expected at least " + minimumSize);
        }
        TypedOutputEvalFunc.safeIncrCounter(klass, "ValidInput", 1L);
    }

    protected static void safeIncrCounter(String group, String name, Long increment) {
        Counter counter = PigStatusReporter.getInstance().getCounter(group, name);
        if (counter != null) {
            counter.increment(increment.longValue());
        }
    }
}

