/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.optimizer;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.optimizer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Rule {
    protected String name = null;
    protected OperatorPlan pattern;
    protected transient OperatorPlan currentPlan;
    protected static final Log log = LogFactory.getLog(Rule.class);
    private transient Set<Operator> matchedNodes = new HashSet<Operator>();
    private boolean mandatory;
    private boolean skipListener = false;

    public Rule(String n, boolean mandatory) {
        this.name = n;
        this.pattern = this.buildPattern();
        this.mandatory = mandatory;
    }

    public Rule(String n, OperatorPlan p) {
        this.name = n;
        this.pattern = p;
    }

    protected abstract OperatorPlan buildPattern();

    public abstract Transformer getNewTransformer();

    public OperatorPlan getPattern() {
        return this.pattern;
    }

    protected boolean isSkipListener() {
        return this.skipListener;
    }

    protected void setSkipListener(boolean skip) {
        this.skipListener = skip;
    }

    public List<OperatorPlan> match(OperatorPlan plan) throws FrontendException {
        this.currentPlan = plan;
        List<Operator> leaves = this.pattern.getSinks();
        Iterator<Operator> iter = plan.getOperators();
        ArrayList<OperatorPlan> matchedList = new ArrayList<OperatorPlan>();
        this.matchedNodes.clear();
        while (iter.hasNext()) {
            PatternMatchOperatorPlan match;
            Operator op = iter.next();
            if (!this.match(op, leaves.get(0))) continue;
            ArrayList<Operator> planOps = new ArrayList<Operator>();
            planOps.add(op);
            if (leaves.size() > 1) {
                boolean matched = true;
                List<Operator> preds = null;
                preds = plan.getPredecessors(op);
                if (preds == null) {
                    preds = new ArrayList<Operator>();
                    preds.add(null);
                }
                for (Operator s : preds) {
                    int j;
                    matched = true;
                    List<Operator> siblings = null;
                    siblings = s != null ? plan.getSuccessors(s) : plan.getSources();
                    int index = siblings.indexOf(op);
                    if (siblings.size() - index < leaves.size()) continue;
                    for (j = 1; j < leaves.size(); ++j) {
                        if (this.match(siblings.get(index + j), leaves.get(j))) continue;
                        matched = false;
                        break;
                    }
                    if (!matched) continue;
                    for (j = 1; j < leaves.size(); ++j) {
                        planOps.add(siblings.get(index + j));
                    }
                }
                if (!matched) continue;
            }
            if (!(match = new PatternMatchOperatorPlan(plan)).check(planOps)) continue;
            Iterator<Operator> iter2 = match.getOperators();
            while (iter2.hasNext()) {
                Operator opt = iter2.next();
                this.matchedNodes.add(opt);
            }
            matchedList.add(match);
        }
        return matchedList;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    private boolean match(Operator planNode, Operator patternNode) {
        return planNode.getClass().equals(patternNode.getClass()) && !this.matchedNodes.contains(planNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PatternMatchOperatorPlan
    extends OperatorSubPlan {
        public PatternMatchOperatorPlan(OperatorPlan basePlan) {
            super(basePlan);
        }

        protected boolean check(List<Operator> planOps) throws FrontendException {
            List<Operator> patternOps = Rule.this.pattern.getSinks();
            if (planOps.size() != patternOps.size()) {
                return false;
            }
            for (int i = 0; i < planOps.size(); ++i) {
                LinkedList<Operator> s = new LinkedList<Operator>();
                if (!this.check(planOps.get(i), patternOps.get(i), s)) {
                    return false;
                }
                Iterator iter = s.iterator();
                while (iter.hasNext()) {
                    this.add((Operator)iter.next());
                }
            }
            return this.size() == Rule.this.pattern.size();
        }

        private boolean check(Operator planOp, Operator patternOp, Deque<Operator> opers) throws FrontendException {
            if (!Rule.this.match(planOp, patternOp)) {
                return false;
            }
            List<Operator> preds1 = this.getBasePlan().getPredecessors(planOp);
            List<Operator> preds2 = Rule.this.pattern.getPredecessors(patternOp);
            if (preds1 == null && preds2 != null) {
                return false;
            }
            if (preds1 != null && preds2 != null && preds1.size() < preds2.size()) {
                return false;
            }
            if (preds2 == null || preds2.size() == 0) {
                opers.push(planOp);
                return true;
            }
            for (int index = 0; index < preds1.size(); ++index) {
                boolean match = true;
                if (!Rule.this.match(preds1.get(index), preds2.get(0))) continue;
                if (preds1.size() - index < preds2.size()) {
                    return false;
                }
                int oldSize = opers.size();
                for (int i = 0; i < preds2.size(); ++i) {
                    if (this.check(preds1.get(index + i), preds2.get(i), opers)) continue;
                    for (int j = opers.size(); j > oldSize; --j) {
                        opers.pop();
                    }
                    match = false;
                    break;
                }
                if (!match) continue;
                opers.push(planOp);
                return true;
            }
            return false;
        }
    }
}

