/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class LessThanExpr
extends BinaryComparisonOperator {
    private static final long serialVersionUID = 1L;
    private final transient Log log = LogFactory.getLog(this.getClass());

    public LessThanExpr(OperatorKey k) {
        this(k, -1);
    }

    public LessThanExpr(OperatorKey k, int rp) {
        super(k, rp);
        this.resultType = (byte)5;
    }

    public String name() {
        return "Less Than[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitLessThan(this);
    }

    public Result getNextBoolean() throws ExecException {
        switch (this.operandType) {
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 30: 
            case 50: 
            case 55: 
            case 65: 
            case 70: {
                Result r = this.accumChild(null, this.operandType);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(this.operandType);
                Result right = this.rhs.getNext(this.operandType);
                return this.doComparison(left, right);
            }
        }
        int errCode = 2067;
        String msg = this.getClass().getSimpleName() + " does not know how to " + "handle type: " + DataType.findTypeName(this.operandType);
        throw new ExecException(msg, errCode, 4);
    }

    private Result doComparison(Result left, Result right) {
        if (left.returnStatus != 0) {
            return left;
        }
        if (right.returnStatus != 0) {
            return right;
        }
        if (left.result == null || right.result == null) {
            left.result = null;
            left.returnStatus = 0;
            return left;
        }
        assert (left.result instanceof Comparable);
        assert (right.result instanceof Comparable);
        left.result = ((Comparable)left.result).compareTo(right.result) < 0 ? Boolean.TRUE : Boolean.FALSE;
        this.illustratorMarkup(null, left.result, (Boolean)left.result != false ? 0 : 1);
        return left;
    }

    public LessThanExpr clone() throws CloneNotSupportedException {
        LessThanExpr clone = new LessThanExpr(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

