/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.pentaho.repository.actions;

import java.awt.Component;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.auth.AuthenticationData;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.pentaho.repository.Messages;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.AuthenticatedServerTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.actions.SelectFileFromRepositoryTask;
import org.pentaho.reporting.designer.extensions.pentaho.repository.util.PublishUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;

public class OpenFileFromRepositoryTask
implements AuthenticatedServerTask {
    private AuthenticationData loginData;
    private boolean storeUpdates;
    private ReportDesignerContext designerContext;
    private Component uiContext;
    private SelectFileFromRepositoryTask selectFileFromRepositoryTask;

    public OpenFileFromRepositoryTask(ReportDesignerContext designerContext, Component uiContext) {
        this.designerContext = designerContext;
        this.uiContext = uiContext;
        this.selectFileFromRepositoryTask = new SelectFileFromRepositoryTask(uiContext);
    }

    @Override
    public void setLoginData(AuthenticationData loginData, boolean storeUpdates) {
        this.loginData = loginData;
        this.storeUpdates = storeUpdates;
    }

    @Override
    public void run() {
        try {
            ReportRenderContext context;
            String oldName = this.loginData.getOption("lastFilename");
            String selectedReport = this.selectFileFromRepositoryTask.selectFile(this.loginData, oldName);
            if (selectedReport == null) {
                return;
            }
            this.loginData.setOption("lastFilename", selectedReport);
            if (this.storeUpdates) {
                this.designerContext.getGlobalAuthenticationStore().add(this.loginData, true);
            }
            if ((context = PublishUtil.openReport(this.designerContext, this.loginData, selectedReport)) != null) {
                context.setProperty("pentaho-login-url", (Object)this.loginData.getUrl());
                context.getAuthenticationStore().add(this.loginData, true);
            }
            this.designerContext.getView().setWelcomeVisible(false);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)this.uiContext, (String)Messages.getInstance().getString("LoadReportFromRepositoryAction.Error.Title"), (String)Messages.getInstance().formatMessage("LoadReportFromRepositoryAction.Error.Message", exception.getMessage()), (Exception)exception);
            UncaughtExceptionsModel.getInstance().addException((Throwable)exception);
        }
    }
}

