/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.SendingRequestEvent;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageEvent;
import com.microsoft.windowsazure.storage.StorageException;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendRequestIntercept
extends StorageEvent<SendingRequestEvent> {
    public static final Log LOG = LogFactory.getLog(SendRequestIntercept.class);
    private static final String ALLOW_ALL_REQUEST_PRECONDITIONS = "*";
    private final StorageCredentials storageCreds;
    private final boolean allowConcurrentOOBIo;
    private final OperationContext opContext;

    private StorageCredentials getCredentials() {
        return this.storageCreds;
    }

    private boolean isOutOfBandIoAllowed() {
        return this.allowConcurrentOOBIo;
    }

    private OperationContext getOperationContext() {
        return this.opContext;
    }

    private SendRequestIntercept(StorageCredentials storageCreds, boolean allowConcurrentOOBIo, OperationContext opContext) {
        this.storageCreds = storageCreds;
        this.allowConcurrentOOBIo = allowConcurrentOOBIo;
        this.opContext = opContext;
    }

    public static void bind(StorageCredentials storageCreds, OperationContext opContext, boolean allowConcurrentOOBIo) {
        SendRequestIntercept sendListener = new SendRequestIntercept(storageCreds, allowConcurrentOOBIo, opContext);
        opContext.getSendingRequestEventHandler().addListener((StorageEvent)sendListener);
    }

    public void eventOccurred(SendingRequestEvent sendEvent) {
        if (!(sendEvent.getConnectionObject() instanceof HttpURLConnection)) {
            return;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)sendEvent.getConnectionObject();
        if (urlConnection.getRequestMethod().equalsIgnoreCase("GET") && this.isOutOfBandIoAllowed()) {
            urlConnection.setRequestProperty("If-Match", ALLOW_ALL_REQUEST_PRECONDITIONS);
            try {
                this.getCredentials().signRequest(urlConnection, -1L, this.getOperationContext());
            }
            catch (InvalidKeyException e) {
                String errString = String.format("Received invalid key exception when attempting sign packet. Cause: %s", e.getCause().toString());
                LOG.error((Object)errString);
            }
            catch (StorageException e) {
                String errString = String.format("Received storage exception when attempting to sign packet. Cause: %s", new Object[]{e, e.getCause().toString()});
                LOG.error((Object)errString);
            }
        }
    }
}

