/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlInsert;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorException;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorScope;

public class TableConstructorNamespace
extends AbstractNamespace {
    private final SqlCall values;
    private final SqlValidatorScope scope;

    TableConstructorNamespace(SqlValidatorImpl validator, SqlCall values, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.values = values;
        this.scope = scope;
    }

    protected RelDataType validateImpl() {
        RelDataType targetRowType;
        if (this.enclosingNode instanceof SqlInsert) {
            SqlInsert node = (SqlInsert)this.enclosingNode;
            targetRowType = this.validator.getValidatedNodeType(node);
        } else {
            targetRowType = this.validator.getUnknownType();
        }
        this.validator.validateValues(this.values, targetRowType, this.scope);
        RelDataType tableConstructorRowType = this.validator.getTableConstructorRowType(this.values, this.scope);
        if (tableConstructorRowType == null) {
            throw this.validator.newValidationError(this.values, new SqlValidatorException("Incompatible types", null));
        }
        return tableConstructorRowType;
    }

    public SqlNode getNode() {
        return this.values;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }
}

