/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.List;
import java.util.Stack;
import org.eigenbase.resource.EigenbaseResource;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.validate.AggregatingScope;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AggChecker
extends SqlBasicVisitor<Void> {
    private final Stack<SqlValidatorScope> scopes = new Stack();
    private final List<SqlNode> groupExprs;
    private boolean distinct;
    private SqlValidatorImpl validator;

    AggChecker(SqlValidatorImpl validator, AggregatingScope scope, List<SqlNode> groupExprs, boolean distinct) {
        this.validator = validator;
        this.groupExprs = groupExprs;
        this.distinct = distinct;
        this.scopes.push(scope);
    }

    boolean isGroupExpr(SqlNode expr) {
        for (SqlNode groupExpr : this.groupExprs) {
            if (!groupExpr.equalsDeep(expr, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Void visit(SqlIdentifier id) {
        if (this.isGroupExpr(id)) {
            return null;
        }
        if (id.isStar()) assert (false) : "star should have been expanded";
        SqlCall call = SqlUtil.makeCall(this.validator.getOperatorTable(), id);
        if (call != null) {
            return call.accept(this);
        }
        SqlIdentifier fqId = this.scopes.peek().fullyQualify(id);
        if (this.isGroupExpr(fqId)) {
            return null;
        }
        SqlNode originalExpr = this.validator.getOriginal(id);
        String exprString = originalExpr.toString();
        throw this.validator.newValidationError(originalExpr, this.distinct ? EigenbaseResource.instance().NotSelectDistinctExpr.ex(exprString) : EigenbaseResource.instance().NotGroupExpr.ex(exprString));
    }

    @Override
    public Void visit(SqlCall call) {
        if (call instanceof SqlCall && call.getOperator().isAggregator()) {
            if (this.distinct) {
                SqlNode originalExpr = this.validator.getOriginal(call);
                String exprString = originalExpr.toString();
                throw this.validator.newValidationError(call, EigenbaseResource.instance().NotSelectDistinctExpr.ex(exprString));
            }
            return null;
        }
        if (this.isGroupExpr(call)) {
            return null;
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        SqlValidatorScope oldScope = this.scopes.peek();
        SqlValidatorScope newScope = oldScope.getOperandScope(call);
        this.scopes.push(newScope);
        call.getOperator().acceptCall(this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
        this.scopes.pop();
        return null;
    }
}

