/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sarg;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.sarg.SargInterval;
import org.eigenbase.sarg.SargSetOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SargIntervalSequence {
    final List<SargInterval> list = new ArrayList<SargInterval>();

    SargIntervalSequence() {
    }

    public boolean isPoint() {
        return this.list.size() == 1 && this.list.get(0).isPoint();
    }

    public boolean isEmpty() {
        return this.list.size() == 1 && this.list.get(0).isEmpty();
    }

    public boolean isRange() {
        return this.list.size() > 1 || this.list.size() == 1 && this.list.get(0).isRange();
    }

    public List<SargInterval> getList() {
        return ImmutableList.copyOf(this.list);
    }

    void addInterval(SargInterval interval) {
        this.list.add(interval);
    }

    public String toString() {
        if (this.list.isEmpty()) {
            return "()";
        }
        if (this.list.size() == 1) {
            return this.list.get(0).toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)SargSetOperator.UNION);
        sb.append("(");
        for (SargInterval interval : this.list) {
            sb.append(" ");
            sb.append(interval);
        }
        sb.append(" )");
        return sb.toString();
    }
}

