/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.optiq.BuiltinMethod;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCost;

public class RelMdPercentageOriginalRows {
    private static final RelMdPercentageOriginalRows INSTANCE = new RelMdPercentageOriginalRows();
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of((List<RelMetadataProvider>)ImmutableList.of((Object)ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.PERCENTAGE_ORIGINAL_ROWS.method, INSTANCE), (Object)ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.CUMULATIVE_COST.method, INSTANCE), (Object)ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.NON_CUMULATIVE_COST.method, INSTANCE)));

    private RelMdPercentageOriginalRows() {
    }

    public Double getPercentageOriginalRows(AggregateRelBase rel) {
        return RelMetadataQuery.getPercentageOriginalRows(rel.getChild());
    }

    public Double getPercentageOriginalRows(UnionRelBase rel) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (RelNode input : rel.getInputs()) {
            double rowCount = RelMetadataQuery.getRowCount(input);
            double percentage = RelMetadataQuery.getPercentageOriginalRows(input);
            if (percentage == 0.0) continue;
            denominator += rowCount / percentage;
            numerator += rowCount;
        }
        return RelMdPercentageOriginalRows.quotientForPercentage(numerator, denominator);
    }

    public Double getPercentageOriginalRows(JoinRelBase rel) {
        double left = RelMetadataQuery.getPercentageOriginalRows(rel.getLeft());
        double right = RelMetadataQuery.getPercentageOriginalRows(rel.getRight());
        return left * right;
    }

    public Double getPercentageOriginalRows(RelNode rel) {
        if (rel.getInputs().size() > 1) {
            return null;
        }
        if (rel.getInputs().size() == 0) {
            return 1.0;
        }
        RelNode child = rel.getInputs().get(0);
        Double childPercentage = RelMetadataQuery.getPercentageOriginalRows(child);
        if (childPercentage == null) {
            return null;
        }
        Double relPercentage = RelMdPercentageOriginalRows.quotientForPercentage(RelMetadataQuery.getRowCount(rel), RelMetadataQuery.getRowCount(child));
        if (relPercentage == null) {
            return null;
        }
        double percent = relPercentage * childPercentage;
        if (percent < 0.0 || percent > 1.0) {
            return null;
        }
        return relPercentage * childPercentage;
    }

    public RelOptCost getCumulativeCost(RelNode rel) {
        RelOptCost cost = RelMetadataQuery.getNonCumulativeCost(rel);
        List<RelNode> inputs = rel.getInputs();
        for (RelNode input : inputs) {
            cost = cost.plus(RelMetadataQuery.getCumulativeCost(input));
        }
        return cost;
    }

    public RelOptCost getNonCumulativeCost(RelNode rel) {
        return rel.computeSelfCost(rel.getCluster().getPlanner());
    }

    private static Double quotientForPercentage(Double numerator, Double denominator) {
        if (numerator == null || denominator == null) {
            return null;
        }
        if (denominator == 0.0) {
            return 1.0;
        }
        return numerator / denominator;
    }
}

