/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.DriverManager;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.jdbc.ConnectionConfig;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.PlannerImpl;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RuleSet;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.sql.fun.SqlStdOperatorTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frameworks {
    private Frameworks() {
    }

    public static Planner getPlanner(ConnectionConfig.Lex lex, Function1<SchemaPlus, Schema> schemaFactory, SqlStdOperatorTable operatorTable, RuleSet ... ruleSets) {
        return new PlannerImpl(lex, schemaFactory, operatorTable, (ImmutableList<RuleSet>)ImmutableList.copyOf((Object[])ruleSets));
    }

    public static <R> R withPlanner(final PlannerAction<R> action) {
        return Frameworks.withPrepare(new PrepareAction<R>(){

            @Override
            public R apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, OptiqServerStatement statement) {
                return action.apply(cluster, relOptSchema, rootSchema);
            }
        });
    }

    public static <R> R withPrepare(PrepareAction<R> action) {
        try {
            Class.forName("net.hydromatic.optiq.jdbc.Driver");
            Connection connection = DriverManager.getConnection("jdbc:optiq:");
            OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
            OptiqServerStatement statement = optiqConnection.createStatement().unwrap(OptiqServerStatement.class);
            return new OptiqPrepareImpl().perform(statement, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PrepareAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3, OptiqServerStatement var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PlannerAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3);
    }
}

