/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Spaces {
    private static final List<String> SPACE_LIST = new SpaceList();
    public static final CharSequence MAX = Spaces.sequence(Integer.MAX_VALUE);

    private Spaces() {
    }

    public static CharSequence sequence(int n) {
        return new SpaceString(n);
    }

    public static String of(int n) {
        return SPACE_LIST.get(n);
    }

    public static Appendable append(Appendable buf, int n) throws IOException {
        buf.append(MAX, 0, n);
        return buf;
    }

    public static PrintWriter append(PrintWriter pw, int n) {
        pw.append(MAX, 0, n);
        return pw;
    }

    public static StringWriter append(StringWriter pw, int n) {
        pw.append(MAX, 0, n);
        return pw;
    }

    public static StringBuilder append(StringBuilder buf, int n) {
        buf.append(MAX, 0, n);
        return buf;
    }

    public static StringBuffer append(StringBuffer buf, int n) {
        buf.append(MAX, 0, n);
        return buf;
    }

    public static String padRight(String string, int n) {
        int x = n - string.length();
        if (x <= 0) {
            return string;
        }
        return Spaces.append(new StringBuilder(string), x).toString();
    }

    public static String padLeft(String string, int n) {
        int x = n - string.length();
        if (x <= 0) {
            return string;
        }
        return Spaces.append(new StringBuilder(), x).append(string).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpaceList
    extends CopyOnWriteArrayList<String> {
        private SpaceList() {
        }

        @Override
        public String get(int index) {
            while (true) {
                try {
                    return (String)super.get(index);
                }
                catch (IndexOutOfBoundsException e) {
                    if (index < 0) {
                        throw e;
                    }
                    this.populate(Math.max(16, index + 1));
                    continue;
                }
                break;
            }
        }

        private synchronized void populate(int newSize) {
            newSize = Math.max(newSize, this.size() * 2);
            final char[] chars = new char[newSize];
            Arrays.fill(chars, ' ');
            final int length = newSize - this.size();
            final int offset = this.size();
            this.addAll(new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return new String(chars, 0, offset + index);
                }

                @Override
                public int size() {
                    return length;
                }
            });
        }
    }

    private static class SpaceString
    implements CharSequence {
        private final int length;

        private SpaceString(int length) {
            this.length = length;
        }

        public String toString() {
            return Spaces.of(this.length);
        }

        public int length() {
            return this.length;
        }

        public char charAt(int index) {
            return ' ';
        }

        public CharSequence subSequence(int start, int end) {
            return new SpaceString(end - start);
        }
    }
}

