/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMultiMap<K, V>
extends HashMap<K, List<V>> {
    public void putMulti(K key, V value) {
        List<V> list = this.put(key, Collections.singletonList(value));
        if (list == null) {
            return;
        }
        if (list.size() == 1) {
            list = new ArrayList<V>(list);
        }
        list.add(value);
        this.put(key, list);
    }

    public Iterator<V[]> arrays(final Comparator<V> comparator) {
        final Iterator iterator = this.values().iterator();
        return new Iterator<V[]>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V[] next() {
                List list = (List)iterator.next();
                Object[] vs = list.toArray();
                Arrays.sort(vs, comparator);
                return vs;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <V> Iterator<V[]> singletonArrayIterator(Comparator<V> comparator, List<V> list) {
        SortedMultiMap<String, List<V>> multiMap = new SortedMultiMap<String, List<V>>();
        multiMap.put("x", list);
        return multiMap.arrays(comparator);
    }
}

