/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.List;
import net.hydromatic.optiq.Parameter;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.Table;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarFunctionImpl
implements ScalarFunction {
    public final Method method;
    private final List<String> path;

    private ScalarFunctionImpl(List<String> path, Method method) {
        this.path = path == null ? null : ImmutableList.copyOf(path);
        this.method = method;
    }

    public static ScalarFunctionImpl create(List<String> path, String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("UDF class '" + className + "' not found");
        }
        Method method = ScalarFunctionImpl.findEvalMethod(clazz);
        if (method == null) {
            throw new RuntimeException("method not found");
        }
        if ((method.getModifiers() & 8) == 0 && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) {
            throw new RuntimeException("declaring class '" + clazz.getName() + "' of non-static UDF must have a public constructor with zero " + "parameters");
        }
        return new ScalarFunctionImpl(path, method);
    }

    private static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || (constructor.getModifiers() & 1) == 0) continue;
            return true;
        }
        return false;
    }

    private static Method findEvalMethod(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals("eval")) continue;
            return method;
        }
        return null;
    }

    @Override
    public List<Parameter> getParameters() {
        final Class[] parameterTypes = this.method.getParameterTypes();
        return new AbstractList<Parameter>(){

            @Override
            public Parameter get(final int index) {
                return new Parameter(){

                    public int getOrdinal() {
                        return index;
                    }

                    public String getName() {
                        return "arg" + index;
                    }

                    public RelDataType getType(RelDataTypeFactory typeFactory) {
                        return typeFactory.createJavaType(parameterTypes[index]);
                    }
                };
            }

            @Override
            public int size() {
                return parameterTypes.length;
            }
        };
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.method.getReturnType());
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Table apply(List<Object> arguments) {
        throw new UnsupportedOperationException();
    }
}

