/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKTableReadOnly;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.KeeperException;

class ZooKeeperRegistry
implements Registry {
    static final Log LOG = LogFactory.getLog(ZooKeeperRegistry.class);
    ConnectionManager.HConnectionImplementation hci;
    private String clusterId = null;

    ZooKeeperRegistry() {
    }

    @Override
    public void init(HConnection connection) {
        if (!(connection instanceof ConnectionManager.HConnectionImplementation)) {
            throw new RuntimeException("This registry depends on HConnectionImplementation");
        }
        this.hci = (ConnectionManager.HConnectionImplementation)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionLocations getMetaRegionLocation() throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
            }
            ServerName servername = MetaRegionTracker.blockUntilAvailable(zkw, this.hci.rpcTimeout);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looked up meta region location, connection=" + this + "; serverName=" + (servername == null ? "null" : servername)));
            }
            if (servername == null) {
                RegionLocations regionLocations = null;
                return regionLocations;
            }
            HRegionLocation loc = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, servername, 0L);
            RegionLocations regionLocations = new RegionLocations(loc);
            return regionLocations;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            RegionLocations regionLocations = null;
            return regionLocations;
        }
        finally {
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        ZooKeeperKeepAliveConnection zkw = null;
        try {
            zkw = this.hci.getKeepAliveZooKeeperWatcher();
            this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (this.clusterId == null) {
                LOG.info((Object)"ClusterId read in ZooKeeper is null");
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't retrieve clusterId from Zookeeper", (Throwable)e);
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
        }
        return this.clusterId;
    }

    @Override
    public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            if (enabled) {
                boolean bl = ZKTableReadOnly.isEnabledTable(zkw, tableName);
                return bl;
            }
            boolean bl = ZKTableReadOnly.isDisabledTable(zkw, tableName);
            return bl;
        }
        catch (KeeperException e) {
            throw new IOException("Enable/Disable failed", e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            zkw.close();
        }
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();
        try {
            int n = ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
            return n;
        }
        catch (KeeperException ke) {
            throw new IOException("Unexpected ZooKeeper exception", ke);
        }
        finally {
            zkw.close();
        }
    }
}

