/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput;

import java.util.HashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableOutputData;
import org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableOutputMeta;
import org.pentaho.di.trans.steps.cassandrasstableoutput.SSTableWriter;

public class SSTableOutput
extends BaseStep
implements StepInterface {
    protected SSTableOutputMeta m_meta;
    protected SSTableOutputData m_data;
    protected int rowsSeen;
    protected String directory;
    protected String keyspace;
    protected String columnFamily;
    protected String keyField;
    protected String bufferSize;
    protected SSTableWriter writer;
    protected RowMetaInterface inputMetadata;
    private String[] fieldNames;
    private int[] fieldValueIndices;

    public SSTableOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void initialize(StepMetaInterface smi, StepDataInterface sdi) throws Exception {
        this.first = false;
        this.rowsSeen = 0;
        this.m_meta = (SSTableOutputMeta)smi;
        this.m_data = (SSTableOutputData)sdi;
        this.inputMetadata = this.getInputRowMeta();
        String yamlPath = this.environmentSubstitute(this.m_meta.getYamlPath());
        if (Const.isEmpty((String)yamlPath)) {
            throw new Exception(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoPathToYAML", (String[])new String[0]));
        }
        this.logBasic(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Message.YAMLPath", (String[])new String[]{yamlPath}));
        System.setProperty("cassandra.config", "file:" + yamlPath);
        this.directory = this.environmentSubstitute(this.m_meta.getDirectory());
        this.keyspace = this.environmentSubstitute(this.m_meta.getCassandraKeyspace());
        this.columnFamily = this.environmentSubstitute(this.m_meta.getColumnFamilyName());
        this.keyField = this.environmentSubstitute(this.m_meta.getKeyField());
        this.bufferSize = this.environmentSubstitute(this.m_meta.getBufferSize());
        if (Const.isEmpty((String)this.columnFamily)) {
            throw new KettleException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoColumnFamilySpecified", (String[])new String[0]));
        }
        if (Const.isEmpty((String)this.keyField)) {
            throw new KettleException(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.NoKeySpecified", (String[])new String[0]));
        }
        this.fieldNames = this.inputMetadata.getFieldNames();
        this.fieldValueIndices = new int[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            this.fieldValueIndices[i] = this.inputMetadata.indexOfValue(this.fieldNames[i]);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.writer = new SSTableWriter();
        this.writer.setDirectory(this.directory);
        this.writer.setKeyspace(this.keyspace);
        this.writer.setColumnFamily(this.columnFamily);
        this.writer.setKeyField(this.keyField);
        this.writer.setBufferSize(Integer.parseInt(this.bufferSize));
        this.writer.init();
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.isStopped()) {
            return false;
        }
        Object[] r = this.getRow();
        try {
            if (r == null) {
                this.setOutputDone();
                this.closeWriter();
                return false;
            }
            if (this.first) {
                this.initialize(smi, sdi);
            }
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (int i = 0; i < this.fieldNames.length; ++i) {
                Object value = r[this.fieldValueIndices[i]];
                if (SSTableWriter.isNull(value)) continue;
                record.put(this.fieldNames[i], value);
            }
            this.writer.processRow(record);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.FailedToProcessRow", (String[])new String[0]), e);
            this.putError(this.getInputRowMeta(), r, 1L, e.getMessage(), null, "ERR_SSTABLE_OUTPUT_01");
        }
        return true;
    }

    public void setStopped(boolean stopped) {
        super.setStopped(stopped);
        if (stopped) {
            this.closeWriter();
        }
    }

    public void closeWriter() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(SSTableOutputMeta.PKG, (String)"SSTableOutput.Error.FailedToCloseWriter", (String[])new String[0]), e);
            }
        }
    }
}

