/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.trove.ExtTIntArrayList;

public class FetchSearchRequest
implements Streamable {
    private long id;
    private int[] docIds;
    private int size;

    public FetchSearchRequest() {
    }

    public FetchSearchRequest(long id, ExtTIntArrayList list) {
        this.id = id;
        this.docIds = list.unsafeArray();
        this.size = list.size();
    }

    public FetchSearchRequest(long id, int[] docIds) {
        this.id = id;
        this.docIds = docIds;
        this.size = docIds.length;
    }

    public long id() {
        return this.id;
    }

    public int[] docIds() {
        return this.docIds;
    }

    public int docIdsSize() {
        return this.size;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readLong();
        this.size = in.readVInt();
        this.docIds = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.docIds[i] = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeVInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeVInt(this.docIds[i]);
        }
    }
}

