/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.FastByteArrayInputStream;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.yaml.snakeyaml.Yaml;

public class YamlSettingsLoader
implements SettingsLoader {
    @Override
    public Map<String, String> load(String source) throws IOException {
        source = source.replace("\t", "  ");
        Yaml yaml = new Yaml();
        Map yamlMap = (Map)yaml.load(source);
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> settings = Maps.newHashMap();
        if (yamlMap == null) {
            return settings;
        }
        ArrayList<String> path = Lists.newArrayList();
        this.serializeMap(settings, sb, path, yamlMap);
        return settings;
    }

    @Override
    public Map<String, String> load(byte[] source) throws IOException {
        Yaml yaml = new Yaml();
        Map yamlMap = (Map)yaml.load(new FastByteArrayInputStream(source));
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> settings = Maps.newHashMap();
        if (yamlMap == null) {
            return settings;
        }
        ArrayList<String> path = Lists.newArrayList();
        this.serializeMap(settings, sb, path, yamlMap);
        return settings;
    }

    private void serializeMap(Map<String, String> settings, StringBuilder sb, List<String> path, Map<Object, Object> yamlMap) {
        for (Map.Entry<Object, Object> entry : yamlMap.entrySet()) {
            if (entry.getValue() instanceof Map) {
                path.add((String)entry.getKey());
                this.serializeMap(settings, sb, path, (Map)entry.getValue());
                path.remove(path.size() - 1);
                continue;
            }
            if (entry.getValue() instanceof List) {
                path.add((String)entry.getKey());
                this.serializeList(settings, sb, path, (List)entry.getValue());
                path.remove(path.size() - 1);
                continue;
            }
            this.serializeValue(settings, sb, path, (String)entry.getKey(), entry.getValue());
        }
    }

    private void serializeList(Map<String, String> settings, StringBuilder sb, List<String> path, List yamlList) {
        int counter = 0;
        for (Object listEle : yamlList) {
            if (listEle instanceof Map) {
                path.add(Integer.toString(counter));
                this.serializeMap(settings, sb, path, (Map)listEle);
                path.remove(path.size() - 1);
            } else if (listEle instanceof List) {
                path.add(Integer.toString(counter));
                this.serializeList(settings, sb, path, (List)listEle);
                path.remove(path.size() - 1);
            } else {
                this.serializeValue(settings, sb, path, Integer.toString(counter), listEle);
            }
            ++counter;
        }
    }

    private void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, String name, Object value) {
        if (value == null) {
            return;
        }
        sb.setLength(0);
        for (String pathEle : path) {
            sb.append(pathEle).append('.');
        }
        sb.append(name);
        settings.put(sb.toString(), value.toString());
    }
}

