/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.OpenBitDocSet;

public class DocSets {
    public static DocSet convert(IndexReader reader, DocIdSet docIdSet) throws IOException {
        if (docIdSet == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (docIdSet instanceof DocSet) {
            return (DocSet)docIdSet;
        }
        if (docIdSet instanceof OpenBitSet) {
            return new OpenBitDocSet((OpenBitSet)docIdSet);
        }
        DocIdSetIterator it = docIdSet.iterator();
        return it == null ? DocSet.EMPTY_DOC_SET : new OpenBitDocSet(it, reader.maxDoc());
    }

    public static DocSet cacheable(IndexReader reader, DocIdSet docIdSet) throws IOException {
        if (docIdSet == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (docIdSet.isCacheable() && docIdSet instanceof DocSet) {
            return (DocSet)docIdSet;
        }
        if (docIdSet instanceof OpenBitSet) {
            return new OpenBitDocSet((OpenBitSet)docIdSet);
        }
        DocIdSetIterator it = docIdSet.iterator();
        return it == null ? DocSet.EMPTY_DOC_SET : new OpenBitDocSet(it, reader.maxDoc());
    }

    private DocSets() {
    }
}

