/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.io.OutputStream;

public abstract class StreamOutput
extends OutputStream {
    private byte[] bytearr = null;
    private static byte ZERO = 0;
    private static byte ONE = 1;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public final void writeShort(short v) throws IOException {
        this.writeByte((byte)(v >> 8));
        this.writeByte((byte)v);
    }

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (this.bytearr == null || this.bytearr.length < utflen + 4) {
            this.bytearr = new byte[utflen * 2 + 4];
        }
        byte[] bytearr = this.bytearr;
        bytearr[count++] = (byte)(utflen >> 24);
        bytearr[count++] = (byte)(utflen >> 16);
        bytearr[count++] = (byte)(utflen >> 8);
        bytearr[count++] = (byte)utflen;
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.writeBytes(bytearr, 0, utflen + 4);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }
}

