/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.concurrentlinkedhashmap;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.concurrentlinkedhashmap.EvictionListener;
import org.elasticsearch.common.concurrentlinkedhashmap.GuardedBy;
import org.elasticsearch.common.concurrentlinkedhashmap.Immutable;
import org.elasticsearch.common.concurrentlinkedhashmap.Linked;
import org.elasticsearch.common.concurrentlinkedhashmap.LinkedDeque;
import org.elasticsearch.common.concurrentlinkedhashmap.ThreadSafe;
import org.elasticsearch.common.concurrentlinkedhashmap.Weigher;
import org.elasticsearch.common.concurrentlinkedhashmap.Weighers;

@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAXIMUM_WEIGHT = 0x20000000;
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    static final int BUFFER_THRESHOLD = 16;
    static final int NUMBER_OF_BUFFERS;
    static final int BUFFER_MASK;
    static final int AMORTIZED_DRAIN_THRESHOLD;
    static final Queue<?> DISCARDING_QUEUE;
    final ConcurrentMap<K, Node> data;
    final int concurrencyLevel;
    @GuardedBy(value="evictionLock")
    final LinkedDeque<Node> evictionDeque;
    volatile int capacity;
    @GuardedBy(value="evictionLock")
    volatile int weightedSize;
    volatile int nextOrder;
    @GuardedBy(value="evictionLock")
    int drainedOrder;
    final Lock evictionLock;
    final Queue<Task>[] buffers;
    final ExecutorService executor;
    final BoundedWeigher<V> weigher;
    final AtomicIntegerArray bufferLengths;
    final AtomicReference<DrainStatus> drainStatus;
    final Queue<Node> pendingNotifications;
    final EvictionListener<K, V> listener;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        this.concurrencyLevel = builder.concurrencyLevel;
        this.capacity = Math.min(builder.capacity, 0x40000000);
        this.data = new ConcurrentHashMap<K, Node>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.executor = builder.executor;
        this.nextOrder = Integer.MIN_VALUE;
        this.drainedOrder = Integer.MIN_VALUE;
        this.evictionLock = new ReentrantLock();
        this.evictionDeque = new LinkedDeque();
        this.weigher = new BoundedWeigher(builder.weigher);
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.buffers = new Queue[NUMBER_OF_BUFFERS];
        this.bufferLengths = new AtomicIntegerArray(NUMBER_OF_BUFFERS);
        for (int i = 0; i < NUMBER_OF_BUFFERS; ++i) {
            this.buffers[i] = new ConcurrentLinkedQueue<Task>();
        }
        this.listener = builder.listener;
        this.pendingNotifications = this.listener == DiscardingListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = Math.min(capacity, 0x40000000);
        this.evictionLock.lock();
        try {
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    boolean hasOverflowed() {
        return this.weightedSize > this.capacity;
    }

    @GuardedBy(value="evictionLock")
    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.pendingNotifications.add(node);
            }
            node.makeDead();
        }
    }

    void afterCompletion(Task task) {
        boolean delayable = this.schedule(task);
        if (this.shouldDrainBuffers(delayable)) {
            this.tryToDrainBuffers(AMORTIZED_DRAIN_THRESHOLD);
        }
        this.notifyListener();
    }

    private boolean schedule(Task task) {
        int index = ConcurrentLinkedHashMap.bufferIndex();
        int buffered = this.bufferLengths.incrementAndGet(index);
        if (task.isWrite()) {
            this.buffers[index].add(task);
            this.drainStatus.set(DrainStatus.REQUIRED);
            return false;
        }
        if (buffered <= 0x100000) {
            this.buffers[index].add(task);
            return buffered <= 16;
        }
        this.bufferLengths.decrementAndGet(index);
        return false;
    }

    static int bufferIndex() {
        return (int)Thread.currentThread().getId() & BUFFER_MASK;
    }

    int nextOrdering() {
        return this.nextOrder++;
    }

    boolean shouldDrainBuffers(boolean delayable) {
        if (this.executor.isShutdown()) {
            DrainStatus status = this.drainStatus.get();
            return status != DrainStatus.PROCESSING && (!delayable || status == DrainStatus.REQUIRED);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToDrainBuffers(int maxToDrain) {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.set(DrainStatus.PROCESSING);
                this.drainBuffers(maxToDrain);
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainBuffers(int maxToDrain) {
        Task[] tasks = new Task[maxToDrain];
        int maxTaskIndex = this.moveTasksFromBuffers(tasks);
        this.runTasks(tasks, maxTaskIndex);
        this.updateDrainedOrder(tasks, maxTaskIndex);
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffers(Task[] tasks) {
        int maxTaskIndex = -1;
        for (int i = 0; i < this.buffers.length; ++i) {
            int maxIndex = this.moveTasksFromBuffer(i, tasks);
            maxTaskIndex = Math.max(maxIndex, maxTaskIndex);
        }
        return maxTaskIndex;
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffer(int bufferIndex, Task[] tasks) {
        Task task;
        Queue<Task> buffer = this.buffers[bufferIndex];
        int removedFromBuffer = 0;
        int maxIndex = -1;
        while ((task = buffer.poll()) != null) {
            ++removedFromBuffer;
            int index = task.getOrder() - this.drainedOrder;
            if (index < 0) {
                task.run();
                continue;
            }
            if (index >= tasks.length) {
                maxIndex = tasks.length - 1;
                this.addTaskToChain(tasks, task, maxIndex);
                break;
            }
            maxIndex = Math.max(index, maxIndex);
            this.addTaskToChain(tasks, task, index);
        }
        this.bufferLengths.addAndGet(bufferIndex, -removedFromBuffer);
        return maxIndex;
    }

    @GuardedBy(value="evictionLock")
    void addTaskToChain(Task[] tasks, Task task, int index) {
        task.setNext(tasks[index]);
        tasks[index] = task;
    }

    @GuardedBy(value="evictionLock")
    void runTasks(Task[] tasks, int maxTaskIndex) {
        for (int i = 0; i <= maxTaskIndex; ++i) {
            this.runTasksInChain(tasks[i]);
        }
    }

    @GuardedBy(value="evictionLock")
    void runTasksInChain(Task task) {
        while (task != null) {
            Task current = task;
            task = task.getNext();
            current.setNext(null);
            current.run();
        }
    }

    @GuardedBy(value="evictionLock")
    void updateDrainedOrder(Task[] tasks, int maxTaskIndex) {
        if (maxTaskIndex >= 0) {
            Task task = tasks[maxTaskIndex];
            this.drainedOrder = task.getOrder() + 1;
        }
    }

    void notifyListener() {
        Node node;
        while ((node = this.pendingNotifications.poll()) != null) {
            this.listener.onEviction(node.key, node.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public int weightedSize() {
        return Math.max(0, this.weightedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                node.makeDead();
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                Task task;
                Queue<Task> buffer = this.buffers[i];
                int removed = 0;
                while ((task = buffer.poll()) != null) {
                    if (task.isWrite()) {
                        task.run();
                    }
                    ++removed;
                }
                this.bufferLengths.addAndGet(i, -removed);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        ConcurrentLinkedHashMap.checkNotNull(value);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        this.afterCompletion(new ReadTask(node));
        return node.getValue();
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    V put(K key, V value, boolean onlyIfAbsent) {
        WeightedValue oldWeightedValue;
        Node prior;
        ConcurrentLinkedHashMap.checkNotNull(value);
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = new Node(key, weightedValue);
        block0: while (true) {
            if ((prior = this.data.putIfAbsent(node.key, node)) == null) {
                this.afterCompletion(new AddTask(node, weight));
                return null;
            }
            if (onlyIfAbsent) {
                this.afterCompletion(new ReadTask(prior));
                return prior.getValue();
            }
            do {
                if (!(oldWeightedValue = (WeightedValue)prior.get()).isAlive()) continue block0;
            } while (!prior.compareAndSet(oldWeightedValue, weightedValue));
            break;
        }
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(prior) : new UpdateTask(prior, weightedDifference);
        this.afterCompletion(task);
        return oldWeightedValue.value;
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.data.remove(key);
        if (node == null) {
            return null;
        }
        node.makeRetired();
        this.afterCompletion(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        Node node = (Node)this.data.get(key);
        if (node == null || value == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        if (weightedValue.hasValue(value) && node.tryToRetire(weightedValue) && this.data.remove(key, node)) {
            this.afterCompletion(new RemovalTask(node));
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        WeightedValue oldWeightedValue;
        ConcurrentLinkedHashMap.checkNotNull(value);
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        do {
            if ((oldWeightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(oldWeightedValue, weightedValue));
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(node) : new UpdateTask(node, weightedDifference);
        this.afterCompletion(task);
        return oldWeightedValue.value;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(oldValue);
        ConcurrentLinkedHashMap.checkNotNull(newValue);
        int weight = this.weigher.weightOf(newValue);
        WeightedValue<V> newWeightedValue = new WeightedValue<V>(newValue, weight);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.hasValue(oldValue)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, newWeightedValue));
        int weightedDifference = weight - weightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(node) : new UpdateTask(node, weightedDifference);
        this.afterCompletion(task);
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    public Set<K> ascendingKeySet() {
        return this.orderedKeySet(true, Integer.MAX_VALUE);
    }

    public Set<K> ascendingKeySetWithLimit(int limit) {
        return this.orderedKeySet(true, limit);
    }

    public Set<K> descendingKeySet() {
        return this.orderedKeySet(false, Integer.MAX_VALUE);
    }

    public Set<K> descendingKeySetWithLimit(int limit) {
        return this.orderedKeySet(false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<K> orderedKeySet(boolean ascending, int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException();
        }
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int size = Math.min(limit, this.evictionDeque.size());
            LinkedHashSet keys = new LinkedHashSet(size);
            Iterator<Node> iterator2 = iterator = ascending ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (size > keys.size()) {
                keys.add(iterator.next().key);
            }
            Set set = Collections.unmodifiableSet(keys);
            return set;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    public Map<K, V> ascendingMap() {
        return this.orderedMap(true, Integer.MAX_VALUE);
    }

    public Map<K, V> ascendingMapWithLimit(int limit) {
        return this.orderedMap(true, limit);
    }

    public Map<K, V> descendingMap() {
        return this.orderedMap(false, Integer.MAX_VALUE);
    }

    public Map<K, V> descendingMapWithLimit(int limit) {
        return this.orderedMap(false, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(boolean ascending, int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException();
        }
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int size = Math.min(limit, this.evictionDeque.size());
            LinkedHashMap map = new LinkedHashMap(size);
            Iterator<Node> iterator2 = iterator = ascending ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (size > map.size()) {
                Node node = iterator.next();
                map.put(node.key, node.getValue());
            }
            Map map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static {
        int buffers;
        DISCARDING_QUEUE = new DiscardingQueue();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        for (buffers = 1; buffers < availableProcessors; buffers <<= 1) {
        }
        AMORTIZED_DRAIN_THRESHOLD = (1 + buffers) * 16;
        NUMBER_OF_BUFFERS = buffers;
        BUFFER_MASK = buffers - 1;
    }

    public static final class Builder<K, V> {
        static final ExecutorService DEFAULT_EXECUTOR = new DisabledExecutorService();
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        EvictionListener<K, V> listener;
        Weigher<? super V> weigher;
        ExecutorService executor = DEFAULT_EXECUTOR;
        TimeUnit unit;
        long delay;
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        int capacity = -1;

        public Builder() {
            this.weigher = Weighers.singleton();
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException();
            }
            this.initialCapacity = initialCapacity;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(int capacity) {
            if (capacity < 0) {
                throw new IllegalArgumentException();
            }
            this.capacity = capacity;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int concurrencyLevel) {
            if (concurrencyLevel <= 0) {
                throw new IllegalArgumentException();
            }
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> listener) {
            ConcurrentLinkedHashMap.checkNotNull(listener);
            this.listener = listener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            ConcurrentLinkedHashMap.checkNotNull(weigher);
            this.weigher = weigher;
            return this;
        }

        public Builder<K, V> catchup(ScheduledExecutorService executor, long delay, TimeUnit unit) {
            if (delay <= 0L) {
                throw new IllegalArgumentException();
            }
            ConcurrentLinkedHashMap.checkNotNull(executor);
            ConcurrentLinkedHashMap.checkNotNull((Object)unit);
            this.executor = executor;
            this.delay = delay;
            this.unit = unit;
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            if (this.capacity < 0) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap map = new ConcurrentLinkedHashMap(this);
            if (this.executor != DEFAULT_EXECUTOR) {
                ScheduledExecutorService es = (ScheduledExecutorService)this.executor;
                es.scheduleWithFixedDelay(new CatchUpTask(map), this.delay, this.delay, this.unit);
            }
            return map;
        }
    }

    static final class SerializationProxy<K, V>
    implements Serializable {
        final EvictionListener<K, V> listener;
        final Weigher<? super V> weigher;
        final int concurrencyLevel;
        final Map<K, V> data;
        final int capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> map) {
            this.concurrencyLevel = map.concurrencyLevel;
            this.weigher = map.weigher.delegate;
            this.data = new HashMap<K, V>(map);
            this.capacity = map.capacity;
            this.listener = map.listener;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> map = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            map.putAll(this.data);
            return map;
        }
    }

    abstract class AbstractTask
    implements Task {
        final int order;
        Task task;

        AbstractTask() {
            this.order = ConcurrentLinkedHashMap.this.nextOrdering();
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public Task getNext() {
            return this.task;
        }

        @Override
        public void setNext(Task task) {
            this.task = task;
        }
    }

    static interface Task
    extends Runnable {
        public int getOrder();

        public boolean isWrite();

        public Task getNext();

        public void setNext(Task var1);
    }

    static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object key, Object value) {
        }
    }

    static final class DiscardingQueue
    extends AbstractQueue<Object> {
        DiscardingQueue() {
        }

        @Override
        public boolean add(Object e) {
            return true;
        }

        @Override
        public boolean offer(Object e) {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    static final class DisabledExecutorService
    extends AbstractExecutorService {
        DisabledExecutorService() {
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        @Override
        public void execute(Runnable command) {
            throw new RejectedExecutionException();
        }
    }

    static final class CatchUpTask
    implements Runnable {
        final WeakReference<ConcurrentLinkedHashMap<?, ?>> mapRef;

        CatchUpTask(ConcurrentLinkedHashMap<?, ?> map) {
            this.mapRef = new WeakReference(map);
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap map = (ConcurrentLinkedHashMap)this.mapRef.get();
            if (map == null) {
                throw new CancellationException();
            }
            int pendingTasks = 0;
            for (int i = 0; i < map.buffers.length; ++i) {
                pendingTasks += map.bufferLengths.get(i);
            }
            if (pendingTasks != 0) {
                map.tryToDrainBuffers(pendingTasks + 16);
            }
        }
    }

    static final class BoundedWeigher<V>
    implements Weigher<V> {
        final Weigher<? super V> delegate;

        BoundedWeigher(Weigher<? super V> weigher) {
            this.delegate = weigher;
        }

        @Override
        public int weightOf(V value) {
            int weight = this.delegate.weightOf(value);
            if (weight < 1 || weight > 0x20000000) {
                throw new IllegalArgumentException("invalid weight");
            }
            return weight;
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;

        WriteThroughEntry(Node node) {
            super(node.key, node.getValue());
        }

        @Override
        public V setValue(V value) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), value);
            return super.setValue(value);
        }

        Object writeReplace() {
            return new AbstractMap.SimpleEntry(this);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node> iterator;
        Node current;

        EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final ConcurrentLinkedHashMap<K, V> map;

        EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        final Iterator<Node> iterator;
        Node current;
        V value;

        ValueIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentLinkedHashMap.this.containsValue(o);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        final Iterator<K> iterator;
        K current;

        KeyIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current);
            this.current = null;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return ConcurrentLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.map.data.keySet().toArray(array);
        }
    }

    final class Node
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node> {
        final K key;
        @GuardedBy(value="evictionLock")
        Node prev;
        @GuardedBy(value="evictionLock")
        Node next;

        Node(K key, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = key;
            this.prev = null;
            this.next = null;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node getPrevious() {
            return this.prev;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setPrevious(Node prev) {
            this.prev = prev;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node getNext() {
            return this.next;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setNext(Node next) {
            this.next = next;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }

        void makeRetired() {
            WeightedValue retired;
            WeightedValue current;
            do {
                if ((current = (WeightedValue)this.get()).isAlive()) continue;
                return;
            } while (!this.compareAndSet(current, retired = new WeightedValue(current.value, -current.weight)));
        }

        boolean tryToRetire(WeightedValue<V> expect) {
            if (expect.isAlive()) {
                WeightedValue retired = new WeightedValue(expect.value, -expect.weight);
                return this.compareAndSet(expect, retired);
            }
            return false;
        }

        @GuardedBy(value="evictionLock")
        void makeDead() {
            WeightedValue dead;
            WeightedValue current;
            while (!this.compareAndSet(current = (WeightedValue)this.get(), dead = new WeightedValue(current.value, 0))) {
            }
            ConcurrentLinkedHashMap.this.weightedSize -= Math.abs(current.weight);
        }
    }

    @Immutable
    static final class WeightedValue<V> {
        final int weight;
        final V value;

        WeightedValue(V value, int weight) {
            this.weight = weight;
            this.value = value;
        }

        boolean hasValue(Object o) {
            return o == this.value || this.value.equals(o);
        }

        boolean isAlive() {
            return this.weight > 0;
        }

        boolean isRetired() {
            return this.weight < 0;
        }

        boolean isDead() {
            return this.weight == 0;
        }
    }

    final class UpdateTask
    extends ReadTask {
        final int weightDifference;

        public UpdateTask(Node node, int weightDifference) {
            super(node);
            this.weightDifference = weightDifference;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            super.run();
            ConcurrentLinkedHashMap.this.weightedSize += this.weightDifference;
            ConcurrentLinkedHashMap.this.evict();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    final class RemovalTask
    extends AbstractTask {
        final Node node;

        RemovalTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.evictionDeque.remove(this.node);
            this.node.makeDead();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    final class AddTask
    extends AbstractTask {
        final Node node;
        final int weight;

        AddTask(Node node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += this.weight;
            if (((WeightedValue)this.node.get()).isAlive()) {
                ConcurrentLinkedHashMap.this.evictionDeque.add(this.node);
                ConcurrentLinkedHashMap.this.evict();
            }
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    class ReadTask
    extends AbstractTask {
        final Node node;

        ReadTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (ConcurrentLinkedHashMap.this.evictionDeque.contains(this.node)) {
                ConcurrentLinkedHashMap.this.evictionDeque.moveToBack(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return false;
        }
    }

    static enum DrainStatus {
        IDLE,
        REQUIRED,
        PROCESSING;

    }
}

