/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ClusterBlock
implements Serializable,
Streamable,
ToXContent {
    private int id;
    private String description;
    private ClusterBlockLevel[] levels;
    private boolean retryable;
    private boolean disableStatePersistence = false;

    ClusterBlock() {
    }

    public ClusterBlock(int id, String description, boolean retryable, boolean disableStatePersistence, ClusterBlockLevel ... levels) {
        this.id = id;
        this.description = description;
        this.retryable = retryable;
        this.disableStatePersistence = disableStatePersistence;
        this.levels = levels;
    }

    public int id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public ClusterBlockLevel[] levels() {
        return this.levels;
    }

    public boolean contains(ClusterBlockLevel level) {
        for (ClusterBlockLevel testLevel : this.levels) {
            if (testLevel != level) continue;
            return true;
        }
        return false;
    }

    public boolean retryable() {
        return this.retryable;
    }

    public boolean disableStatePersistence() {
        return this.disableStatePersistence;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.id));
        builder.field("description", this.description);
        builder.field("retryable", this.retryable);
        if (this.disableStatePersistence) {
            builder.field("disable_state_persistence", this.disableStatePersistence);
        }
        builder.startArray("levels");
        for (ClusterBlockLevel level : this.levels) {
            builder.value(level.name().toLowerCase());
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static ClusterBlock readClusterBlock(StreamInput in) throws IOException {
        ClusterBlock block = new ClusterBlock();
        block.readFrom(in);
        return block;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.description = in.readUTF();
        this.levels = new ClusterBlockLevel[in.readVInt()];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = ClusterBlockLevel.fromId(in.readVInt());
        }
        this.retryable = in.readBoolean();
        this.disableStatePersistence = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeUTF(this.description);
        out.writeVInt(this.levels.length);
        for (ClusterBlockLevel level : this.levels) {
            out.writeVInt(level.id());
        }
        out.writeBoolean(this.retryable);
        out.writeBoolean(this.disableStatePersistence);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(",").append(this.description).append(", blocks ");
        for (ClusterBlockLevel level : this.levels) {
            sb.append(level.name()).append(",");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterBlock that = (ClusterBlock)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

