/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.VoidStreamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.VoidTransportResponseHandler;

public class NodeIndexCreatedAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    @Inject
    public NodeIndexCreatedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("cluster/nodeIndexCreated", new NodeIndexCreatedTransportHandler());
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public void nodeIndexCreated(final String index, final String nodeId) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.cached().execute(new Runnable(){

                @Override
                public void run() {
                    NodeIndexCreatedAction.this.innerNodeIndexCreated(index, nodeId);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeIndexCreated", new NodeIndexCreatedMessage(index, nodeId), VoidTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerNodeIndexCreated(String index, String nodeId) {
        for (Listener listener : this.listeners) {
            listener.onNodeIndexCreated(index, nodeId);
        }
    }

    private static class NodeIndexCreatedMessage
    implements Streamable {
        String index;
        String nodeId;

        private NodeIndexCreatedMessage() {
        }

        private NodeIndexCreatedMessage(String index, String nodeId) {
            this.index = index;
            this.nodeId = nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.index);
            out.writeUTF(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readUTF();
            this.nodeId = in.readUTF();
        }
    }

    private class NodeIndexCreatedTransportHandler
    extends BaseTransportRequestHandler<NodeIndexCreatedMessage> {
        static final String ACTION = "cluster/nodeIndexCreated";

        private NodeIndexCreatedTransportHandler() {
        }

        @Override
        public NodeIndexCreatedMessage newInstance() {
            return new NodeIndexCreatedMessage();
        }

        @Override
        public void messageReceived(NodeIndexCreatedMessage message, TransportChannel channel) throws Exception {
            NodeIndexCreatedAction.this.innerNodeIndexCreated(message.index, message.nodeId);
            channel.sendResponse(VoidStreamable.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onNodeIndexCreated(String var1, String var2);
    }
}

