/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.policy.rolebased;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.map.LRUMap;
import org.pentaho.platform.api.engine.IAuthorizationAction;
import org.pentaho.platform.api.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrStringHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.NodeHelper;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.security.policy.rolebased.JcrRoleAuthorizationPolicyUtils;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.pentaho.platform.security.policy.rolebased.messages.Messages;
import org.springframework.util.Assert;

public abstract class AbstractJcrBackedRoleBindingDao
implements IRoleAuthorizationPolicyRoleBindingDao {
    protected ITenantedPrincipleNameResolver tenantedRoleNameUtils;
    protected Map<String, List<IAuthorizationAction>> immutableRoleBindings;
    protected Map<String, List<String>> immutableRoleBindingNames;
    protected Map<String, List<String>> bootstrapRoleBindings;
    protected String superAdminRoleName;
    private List<IAuthorizationAction> authorizationActions = new ArrayList<IAuthorizationAction>();
    public static final String FOLDER_NAME_AUTHZ = ".authz";
    public static final String FOLDER_NAME_ROLEBASED = "roleBased";
    public static final String FOLDER_NAME_RUNTIMEROLES = "runtimeRoles";
    protected Map boundLogicalRoleNamesCache = Collections.synchronizedMap(new LRUMap());

    public AbstractJcrBackedRoleBindingDao(Map<String, List<IAuthorizationAction>> immutableRoleBindings, Map<String, List<String>> bootstrapRoleBindings, String superAdminRoleName, ITenantedPrincipleNameResolver tenantedRoleNameUtils, List<IAuthorizationAction> authorizationActions) {
        Assert.notNull(immutableRoleBindings);
        Assert.notNull(bootstrapRoleBindings);
        Assert.notNull((Object)superAdminRoleName);
        Assert.notNull(authorizationActions);
        this.authorizationActions.addAll(authorizationActions);
        this.immutableRoleBindings = immutableRoleBindings;
        this.bootstrapRoleBindings = bootstrapRoleBindings;
        this.superAdminRoleName = superAdminRoleName;
        this.tenantedRoleNameUtils = tenantedRoleNameUtils;
        this.immutableRoleBindingNames = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<IAuthorizationAction>> entry : immutableRoleBindings.entrySet()) {
            ArrayList<String> roles = new ArrayList<String>();
            for (IAuthorizationAction a : entry.getValue()) {
                roles.add(a.getName());
            }
            this.immutableRoleBindingNames.put(entry.getKey(), roles);
        }
    }

    @Override
    public List<String> getBoundLogicalRoleNames(Session session, List<String> runtimeRoleNames) throws NamespaceException, RepositoryException {
        HashSet<String> boundRoleNames = new HashSet<String>();
        HashMap<ITenant, ArrayList<String>> tenantMap = new HashMap<ITenant, ArrayList<String>>();
        boolean includeSuperAdminLogicalRoles = false;
        for (String string : runtimeRoleNames) {
            if (!this.superAdminRoleName.equals(string)) {
                ITenant tenant = JcrTenantUtils.getTenant(string, false);
                ArrayList<String> runtimeRoles = (ArrayList<String>)tenantMap.get(tenant);
                if (runtimeRoles == null) {
                    runtimeRoles = new ArrayList<String>();
                    tenantMap.put(tenant, runtimeRoles);
                }
                runtimeRoles.add(this.tenantedRoleNameUtils.getPrincipleName(string));
                continue;
            }
            includeSuperAdminLogicalRoles = true;
        }
        for (Map.Entry entry : tenantMap.entrySet()) {
            boundRoleNames.addAll(this.getBoundLogicalRoleNames(session, (ITenant)entry.getKey(), (List)entry.getValue()));
        }
        if (includeSuperAdminLogicalRoles) {
            boundRoleNames.addAll((Collection)this.immutableRoleBindingNames.get(this.superAdminRoleName));
        }
        return new ArrayList<String>(boundRoleNames);
    }

    @Override
    public List<String> getBoundLogicalRoleNames(Session session, ITenant tenant, List<String> runtimeRoleNames) throws NamespaceException, RepositoryException {
        String roleId;
        if (tenant == null || tenant.getId() == null) {
            return this.getBoundLogicalRoleNames(session, runtimeRoleNames);
        }
        if (!TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            return new ArrayList<String>();
        }
        ArrayList<String> uncachedRuntimeRoleNames = new ArrayList<String>();
        HashSet cachedBoundLogicalRoleNames = new HashSet();
        for (String runtimeRoleName : runtimeRoleNames) {
            String roleName = this.tenantedRoleNameUtils.getPrincipleName(runtimeRoleName);
            String roleId2 = this.tenantedRoleNameUtils.getPrincipleId(tenant, runtimeRoleName);
            if (this.boundLogicalRoleNamesCache.containsKey(roleId2)) {
                cachedBoundLogicalRoleNames.addAll((Collection)this.boundLogicalRoleNamesCache.get(roleId2));
                continue;
            }
            uncachedRuntimeRoleNames.add(roleName);
        }
        if (uncachedRuntimeRoleNames.isEmpty()) {
            return new ArrayList<String>(cachedBoundLogicalRoleNames);
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String phoNsPrefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        String onlyPentahoPattern = phoNsPrefix + "*";
        HashMultimap boundLogicalRoleNames = HashMultimap.create();
        Node runtimeRolesFolderNode = this.getRuntimeRolesFolderNode(session, tenant);
        NodeIterator runtimeRoleNodes = runtimeRolesFolderNode.getNodes(onlyPentahoPattern);
        if (!runtimeRoleNodes.hasNext()) {
            for (String runtimeRoleName : uncachedRuntimeRoleNames) {
                roleId = this.tenantedRoleNameUtils.getPrincipleId(tenant, runtimeRoleName);
                if (!this.bootstrapRoleBindings.containsKey(runtimeRoleName)) continue;
                boundLogicalRoleNames.putAll((Object)roleId, (Iterable)this.bootstrapRoleBindings.get(runtimeRoleName));
            }
        } else {
            for (String runtimeRoleName : uncachedRuntimeRoleNames) {
                Node runtimeRoleFolderNode;
                if (!NodeHelper.hasNode(runtimeRolesFolderNode, phoNsPrefix, runtimeRoleName) || !(runtimeRoleFolderNode = NodeHelper.getNode(runtimeRolesFolderNode, phoNsPrefix, runtimeRoleName)).hasProperty(pentahoJcrConstants.getPHO_BOUNDROLES())) continue;
                Value[] values = runtimeRoleFolderNode.getProperty(pentahoJcrConstants.getPHO_BOUNDROLES()).getValues();
                String roleId3 = this.tenantedRoleNameUtils.getPrincipleId(tenant, runtimeRoleName);
                for (Value value : values) {
                    boundLogicalRoleNames.put((Object)roleId3, (Object)value.getString());
                }
            }
        }
        for (String runtimeRoleName : uncachedRuntimeRoleNames) {
            if (!this.immutableRoleBindings.containsKey(runtimeRoleName)) continue;
            roleId = this.tenantedRoleNameUtils.getPrincipleId(tenant, runtimeRoleName);
            boundLogicalRoleNames.putAll((Object)roleId, (Iterable)this.immutableRoleBindingNames.get(runtimeRoleName));
        }
        this.boundLogicalRoleNamesCache.putAll(boundLogicalRoleNames.asMap());
        for (String runtimeRoleName : uncachedRuntimeRoleNames) {
            roleId = this.tenantedRoleNameUtils.getPrincipleId(tenant, runtimeRoleName);
            if (this.boundLogicalRoleNamesCache.containsKey(roleId)) continue;
            this.boundLogicalRoleNamesCache.put(roleId, Collections.emptyList());
        }
        HashSet res = new HashSet();
        res.addAll(cachedBoundLogicalRoleNames);
        res.addAll(boundLogicalRoleNames.values());
        return new ArrayList<String>(res);
    }

    public void setRoleBindings(Session session, ITenant tenant, String runtimeRoleName, List<String> logicalRoleNames) throws NamespaceException, RepositoryException {
        if (tenant == null) {
            tenant = JcrTenantUtils.getTenant(runtimeRoleName, false);
            runtimeRoleName = this.getPrincipalName(runtimeRoleName);
        }
        if (!TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            throw new NotFoundException("Tenant " + tenant.getId() + " not found");
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String phoNsPrefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        String onlyPentahoPattern = phoNsPrefix + "*";
        Node runtimeRolesFolderNode = this.getRuntimeRolesFolderNode(session, tenant);
        NodeIterator runtimeRoleNodes = runtimeRolesFolderNode.getNodes(onlyPentahoPattern);
        int i = 0;
        while (runtimeRoleNodes.hasNext()) {
            runtimeRoleNodes.nextNode();
            ++i;
        }
        if (i == 0) {
            for (Map.Entry<String, List<String>> entry : this.bootstrapRoleBindings.entrySet()) {
                JcrRoleAuthorizationPolicyUtils.internalSetBindings(pentahoJcrConstants, runtimeRolesFolderNode, entry.getKey(), entry.getValue(), phoNsPrefix);
            }
        }
        if (this.isImmutable(runtimeRoleName)) {
            throw new RuntimeException(Messages.getInstance().getString("JcrRoleAuthorizationPolicyRoleBindingDao.ERROR_0001_ATTEMPT_MOD_IMMUTABLE", new Object[]{runtimeRoleName}));
        }
        JcrRoleAuthorizationPolicyUtils.internalSetBindings(pentahoJcrConstants, runtimeRolesFolderNode, runtimeRoleName, logicalRoleNames, phoNsPrefix);
        session.save();
        Assert.isTrue((boolean)NodeHelper.hasNode(runtimeRolesFolderNode, phoNsPrefix, runtimeRoleName));
        String roleId = this.tenantedRoleNameUtils.getPrincipleId(tenant, runtimeRoleName);
        this.boundLogicalRoleNamesCache.put(roleId, logicalRoleNames);
    }

    private String getPrincipalName(String principalId) {
        String principalName = null;
        if (this.tenantedRoleNameUtils != null) {
            principalName = this.tenantedRoleNameUtils.getPrincipleName(principalId);
        }
        return principalName;
    }

    protected boolean isImmutable(String runtimeRoleName) {
        return this.immutableRoleBindings.containsKey(runtimeRoleName);
    }

    protected Map<String, List<String>> getRoleBindings(Session session, ITenant tenant) throws RepositoryException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (tenant == null) {
            tenant = JcrTenantUtils.getTenant();
        }
        if (!TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            return map;
        }
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        String phoNsPrefix = session.getNamespacePrefix("http://www.pentaho.org/jcr/2.0") + ":";
        String onlyPentahoPattern = phoNsPrefix + "*";
        Node runtimeRolesFolderNode = this.getRuntimeRolesFolderNode(session, tenant);
        NodeIterator runtimeRoleNodes = runtimeRolesFolderNode.getNodes(onlyPentahoPattern);
        if (!runtimeRoleNodes.hasNext()) {
            map.putAll(this.bootstrapRoleBindings);
        } else {
            while (runtimeRoleNodes.hasNext()) {
                Value[] values;
                Node runtimeRoleNode = runtimeRoleNodes.nextNode();
                if (!runtimeRoleNode.hasProperty(pentahoJcrConstants.getPHO_BOUNDROLES())) continue;
                String runtimeRoleName = JcrStringHelper.fileNameDecode(runtimeRoleNode.getName().substring(phoNsPrefix.length()));
                ArrayList<String> logicalRoleNames = new ArrayList<String>();
                for (Value value : values = runtimeRoleNode.getProperty(pentahoJcrConstants.getPHO_BOUNDROLES()).getValues()) {
                    logicalRoleNames.add(value.getString());
                }
                map.put(runtimeRoleName, logicalRoleNames);
            }
        }
        map.putAll(this.immutableRoleBindingNames);
        return map;
    }

    public RoleBindingStruct getRoleBindingStruct(Session session, ITenant tenant, String locale) throws RepositoryException {
        return new RoleBindingStruct(this.getMapForLocale(locale), this.getRoleBindings(session, tenant), new HashSet<String>(this.immutableRoleBindingNames.keySet()));
    }

    protected Map<String, String> getMapForLocale(String localeString) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (IAuthorizationAction authorizationAction : this.authorizationActions) {
            map.put(authorizationAction.getName(), authorizationAction.getLocalizedDisplayName(localeString));
        }
        return map;
    }

    public Node getRuntimeRolesFolderNode(Session session, ITenant tenant) throws RepositoryException {
        Node tenantRootFolderNode = null;
        try {
            tenantRootFolderNode = (Node)session.getItem(ServerRepositoryPaths.getTenantRootFolderPath(tenant));
        }
        catch (PathNotFoundException e) {
            throw new RepositoryException("Error retrieving RuntimeRoles for folder, folder not found", (Throwable)e);
        }
        Node authzFolderNode = tenantRootFolderNode.getNode(FOLDER_NAME_AUTHZ);
        Node roleBasedFolderNode = authzFolderNode.getNode(FOLDER_NAME_ROLEBASED);
        return roleBasedFolderNode.getNode(FOLDER_NAME_RUNTIMEROLES);
    }
}

