/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.AbstractColorChooserPanel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorChooserMessages;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorPreviewPanel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExtendedColorModel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.HSBColorSelectorPanel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.RGBColorSelectorPanel;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;

public class CombinedColorChooser
extends AbstractColorChooserPanel {
    private ExtendedColorModel colorModel;
    private ColorSelectionHandler selectionHandler;
    private JRadioButton hueSelector;
    private JRadioButton saturationSelector;
    private JRadioButton valueSelector;
    private ColorPreviewPanel previewPanel = new ColorPreviewPanel();
    private JRadioButton redSelector;
    private JRadioButton greenSelector;
    private JRadioButton blueSelector;
    private JSpinner hue;
    private JSpinner saturation;
    private JSpinner value;
    private JSpinner red;
    private JSpinner green;
    private JSpinner blue;
    private JTextField colorCode;
    private JPanel colorSelectorPanel;
    private CardLayout colorSelectorLayout;
    private HSBColorSelectorPanel hsbColorSelectorPanel;
    private RGBColorSelectorPanel rgbColorSelectorPanel;
    private boolean processExternalEvent;
    private JSlider selectedValueSlider;
    private Object sliderSelector;

    public CombinedColorChooser() {
        this.colorModel = new ExtendedColorModel();
        this.colorModel.addChangeListener(new ExtColorHandler());
        this.selectionHandler = new ColorSelectionHandler();
        this.selectedValueSlider = new JSlider();
        this.selectedValueSlider.setOrientation(1);
        this.selectedValueSlider.addChangeListener(new SliderChangeHandler());
        ColorChooserMessages messages = ColorChooserMessages.getInstance();
        this.hueSelector = new JRadioButton(messages.getString("Hue"));
        this.hueSelector.setSelected(true);
        this.hueSelector.addActionListener(new ChooseHSBComponentActionHandler(HSBColorSelectorPanel.ColorComponents.HUE));
        this.saturationSelector = new JRadioButton(messages.getString("Saturation"));
        this.saturationSelector.addActionListener(new ChooseHSBComponentActionHandler(HSBColorSelectorPanel.ColorComponents.SATURATION));
        this.valueSelector = new JRadioButton(messages.getString("Brightness"));
        this.valueSelector.addActionListener(new ChooseHSBComponentActionHandler(HSBColorSelectorPanel.ColorComponents.BRIGHTNESS));
        this.redSelector = new JRadioButton(messages.getString("Red"));
        this.redSelector.addActionListener(new ChooseRGBComponentActionHandler(RGBColorSelectorPanel.ColorComponents.RED));
        this.greenSelector = new JRadioButton(messages.getString("Green"));
        this.greenSelector.addActionListener(new ChooseRGBComponentActionHandler(RGBColorSelectorPanel.ColorComponents.GREEN));
        this.blueSelector = new JRadioButton(messages.getString("Blue"));
        this.blueSelector.addActionListener(new ChooseRGBComponentActionHandler(RGBColorSelectorPanel.ColorComponents.BLUE));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.hueSelector);
        bg.add(this.saturationSelector);
        bg.add(this.valueSelector);
        bg.add(this.redSelector);
        bg.add(this.greenSelector);
        bg.add(this.blueSelector);
        this.hue = new JSpinner(new SpinnerNumberModel(0, 0, 359, 1));
        this.hue.addChangeListener(new HSBKeyboardInputHandler());
        this.saturation = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.saturation.addChangeListener(new HSBKeyboardInputHandler());
        this.value = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.value.addChangeListener(new HSBKeyboardInputHandler());
        this.red = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.red.addChangeListener(new RGBKeyboardInputHandler());
        this.green = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.green.addChangeListener(new RGBKeyboardInputHandler());
        this.blue = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.blue.addChangeListener(new RGBKeyboardInputHandler());
        this.colorCode = new JTextField();
        this.colorCode.setColumns(6);
        this.colorCode.getDocument().addDocumentListener(new ColorCodeInputHandler());
        this.hsbColorSelectorPanel = new HSBColorSelectorPanel();
        this.rgbColorSelectorPanel = new RGBColorSelectorPanel();
        this.colorSelectorLayout = new CardLayout();
        this.colorSelectorPanel = new JPanel();
        this.colorSelectorPanel.setLayout(this.colorSelectorLayout);
        this.colorSelectorPanel.add("HSB", this.hsbColorSelectorPanel);
        this.colorSelectorPanel.add("RGB", this.rgbColorSelectorPanel);
        this.colorSelectorLayout.first(this.colorSelectorPanel);
        this.buildChooser();
        this.reconfigureSlider((Object)HSBColorSelectorPanel.ColorComponents.HUE);
    }

    private JPanel createValueInputPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.hueSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.hue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)new JLabel("\u00b0"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.saturationSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.saturation, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)new JLabel("%"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.valueSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.value, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)new JLabel("%"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        leftPanel.add(Box.createRigidArea(new Dimension(20, 20)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.redSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.red, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.greenSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.green, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.blueSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.blue, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        leftPanel.add(Box.createRigidArea(new Dimension(20, 20)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        leftPanel.add((Component)new JLabel("#"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        leftPanel.add((Component)this.colorCode, gbc);
        return leftPanel;
    }

    protected void buildChooser() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.colorSelectorPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.selectedValueSlider, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        this.add((Component)this.createPreviewPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        this.add((Component)this.createValueInputPanel(), gbc);
    }

    private JComponent createPreviewPanel() {
        ColorChooserMessages messages = ColorChooserMessages.getInstance();
        JPanel p = new JPanel();
        p.setLayout(new VerticalLayout());
        p.add(new JLabel(messages.getString("New")));
        p.add(this.previewPanel);
        p.add(new JLabel(messages.getString("Old")));
        return p;
    }

    @Override
    public String getDisplayName() {
        ColorChooserMessages messages = ColorChooserMessages.getInstance();
        return messages.getString("CombinedTitle");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(ExtendedColorModel enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        this.rgbColorSelectorPanel.setColorSelectionModel(this.colorModel);
        this.hsbColorSelectorPanel.setColorSelectionModel(this.colorModel);
        ExtendedColorModel colorSelectionModel = this.getColorSelectionModel();
        if (colorSelectionModel != null) {
            colorSelectionModel.addChangeListener(this.selectionHandler);
            this.selectionHandler.stateChanged(null);
            this.previewPanel.setPrevious(colorSelectionModel.getSelectedColor());
        }
    }

    @Override
    public void uninstallChooserPanel() {
        ExtendedColorModel colorSelectionModel = this.getColorSelectionModel();
        if (colorSelectionModel != null) {
            colorSelectionModel.removeChangeListener(this.selectionHandler);
        }
        super.uninstallChooserPanel();
        this.rgbColorSelectorPanel.setColorSelectionModel(null);
        this.hsbColorSelectorPanel.setColorSelectionModel(null);
    }

    private void reconfigureSlider(Object component) {
        this.sliderSelector = null;
        if (HSBColorSelectorPanel.ColorComponents.BRIGHTNESS.equals(component)) {
            this.selectedValueSlider.setMinimum(0);
            this.selectedValueSlider.setMaximum(100);
            this.selectedValueSlider.setValue(this.colorModel.getValue());
        }
        if (HSBColorSelectorPanel.ColorComponents.SATURATION.equals(component)) {
            this.selectedValueSlider.setMinimum(0);
            this.selectedValueSlider.setMaximum(100);
            this.selectedValueSlider.setValue(this.colorModel.getSaturation());
        }
        if (HSBColorSelectorPanel.ColorComponents.HUE.equals(component)) {
            this.selectedValueSlider.setMinimum(0);
            this.selectedValueSlider.setMaximum(359);
            this.selectedValueSlider.setValue(this.colorModel.getHue());
        }
        if (RGBColorSelectorPanel.ColorComponents.RED.equals(component)) {
            this.selectedValueSlider.setMinimum(0);
            this.selectedValueSlider.setMaximum(255);
            this.selectedValueSlider.setValue(this.colorModel.getRed());
        }
        if (RGBColorSelectorPanel.ColorComponents.GREEN.equals(component)) {
            this.selectedValueSlider.setMinimum(0);
            this.selectedValueSlider.setMaximum(255);
            this.selectedValueSlider.setValue(this.colorModel.getGreen());
        }
        if (RGBColorSelectorPanel.ColorComponents.BLUE.equals(component)) {
            this.selectedValueSlider.setMinimum(0);
            this.selectedValueSlider.setMaximum(255);
            this.selectedValueSlider.setValue(this.colorModel.getBlue());
        }
        this.sliderSelector = component;
    }

    private class SliderChangeHandler
    implements ChangeListener {
        private SliderChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (CombinedColorChooser.this.sliderSelector == null) {
                return;
            }
            Object component = CombinedColorChooser.this.sliderSelector;
            if (HSBColorSelectorPanel.ColorComponents.BRIGHTNESS.equals(component)) {
                CombinedColorChooser.this.colorModel.setHSB(CombinedColorChooser.this.colorModel.getHue(), CombinedColorChooser.this.colorModel.getSaturation(), CombinedColorChooser.this.selectedValueSlider.getValue());
            }
            if (HSBColorSelectorPanel.ColorComponents.SATURATION.equals(component)) {
                CombinedColorChooser.this.colorModel.setHSB(CombinedColorChooser.this.colorModel.getHue(), CombinedColorChooser.this.selectedValueSlider.getValue(), CombinedColorChooser.this.colorModel.getValue());
            }
            if (HSBColorSelectorPanel.ColorComponents.HUE.equals(component)) {
                CombinedColorChooser.this.colorModel.setHSB(CombinedColorChooser.this.selectedValueSlider.getValue(), CombinedColorChooser.this.colorModel.getSaturation(), CombinedColorChooser.this.colorModel.getValue());
            }
            if (RGBColorSelectorPanel.ColorComponents.RED.equals(component)) {
                CombinedColorChooser.this.colorModel.setRGB(CombinedColorChooser.this.selectedValueSlider.getValue(), CombinedColorChooser.this.colorModel.getGreen(), CombinedColorChooser.this.colorModel.getBlue());
            }
            if (RGBColorSelectorPanel.ColorComponents.GREEN.equals(component)) {
                CombinedColorChooser.this.colorModel.setRGB(CombinedColorChooser.this.colorModel.getRed(), CombinedColorChooser.this.selectedValueSlider.getValue(), CombinedColorChooser.this.colorModel.getBlue());
            }
            if (RGBColorSelectorPanel.ColorComponents.BLUE.equals(component)) {
                CombinedColorChooser.this.colorModel.setRGB(CombinedColorChooser.this.colorModel.getRed(), CombinedColorChooser.this.colorModel.getGreen(), CombinedColorChooser.this.selectedValueSlider.getValue());
            }
        }
    }

    private class ColorCodeInputHandler
    extends DocumentChangeHandler {
        private ColorCodeInputHandler() {
        }

        @Override
        protected void handleChange(DocumentEvent e) {
            if (CombinedColorChooser.this.processExternalEvent) {
                return;
            }
            String text = CombinedColorChooser.this.colorCode.getText();
            try {
                int value = Integer.parseInt(text, 16);
                CombinedColorChooser.this.colorModel.setSelectedColor(new Color(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class RGBKeyboardInputHandler
    implements ChangeListener {
        private RGBKeyboardInputHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (CombinedColorChooser.this.processExternalEvent) {
                return;
            }
            CombinedColorChooser.this.colorModel.setRGB((Integer)CombinedColorChooser.this.red.getValue(), (Integer)CombinedColorChooser.this.green.getValue(), (Integer)CombinedColorChooser.this.blue.getValue());
        }
    }

    private class HSBKeyboardInputHandler
    implements ChangeListener {
        private HSBKeyboardInputHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (CombinedColorChooser.this.processExternalEvent) {
                return;
            }
            CombinedColorChooser.this.colorModel.setHSB((Integer)CombinedColorChooser.this.hue.getValue(), (Integer)CombinedColorChooser.this.saturation.getValue(), (Integer)CombinedColorChooser.this.value.getValue());
        }
    }

    private class ExtColorHandler
    implements ChangeListener {
        private ExtColorHandler() {
        }

        private String colorToHex(Color c) {
            String color = Integer.toHexString(c.getRGB() & 0xFFFFFF);
            StringBuffer retval = new StringBuffer(6);
            int fillUp = 6 - color.length();
            for (int i = 0; i < fillUp; ++i) {
                retval.append('0');
            }
            retval.append(color);
            return retval.toString().toUpperCase();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (CombinedColorChooser.this.processExternalEvent) {
                return;
            }
            try {
                CombinedColorChooser.this.processExternalEvent = true;
                Color color = CombinedColorChooser.this.colorModel.getSelectedColor();
                CombinedColorChooser.this.getColorSelectionModel().copyInto(CombinedColorChooser.this.colorModel);
                CombinedColorChooser.this.red.setValue(CombinedColorChooser.this.colorModel.getRed());
                CombinedColorChooser.this.green.setValue(CombinedColorChooser.this.colorModel.getGreen());
                CombinedColorChooser.this.blue.setValue(CombinedColorChooser.this.colorModel.getBlue());
                CombinedColorChooser.this.hue.setValue(CombinedColorChooser.this.colorModel.getHue());
                CombinedColorChooser.this.saturation.setValue(CombinedColorChooser.this.colorModel.getSaturation());
                CombinedColorChooser.this.value.setValue(CombinedColorChooser.this.colorModel.getValue());
                CombinedColorChooser.this.colorCode.setText(this.colorToHex(color));
                CombinedColorChooser.this.previewPanel.setCurrent(color);
            }
            finally {
                CombinedColorChooser.this.processExternalEvent = false;
            }
        }
    }

    private class ColorSelectionHandler
    implements ChangeListener {
        private ColorSelectionHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Color color = CombinedColorChooser.this.getColorFromModel();
            CombinedColorChooser.this.colorModel.setSelectedColor(color);
        }
    }

    private class ChooseHSBComponentActionHandler
    implements ActionListener {
        private HSBColorSelectorPanel.ColorComponents component;

        private ChooseHSBComponentActionHandler(HSBColorSelectorPanel.ColorComponents component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CombinedColorChooser.this.hsbColorSelectorPanel.setComponent(this.component);
            CombinedColorChooser.this.colorSelectorLayout.first(CombinedColorChooser.this.colorSelectorPanel);
            CombinedColorChooser.this.reconfigureSlider((Object)this.component);
        }
    }

    private class ChooseRGBComponentActionHandler
    implements ActionListener {
        private RGBColorSelectorPanel.ColorComponents component;

        private ChooseRGBComponentActionHandler(RGBColorSelectorPanel.ColorComponents component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CombinedColorChooser.this.rgbColorSelectorPanel.setComponent(this.component);
            CombinedColorChooser.this.colorSelectorLayout.last(CombinedColorChooser.this.colorSelectorPanel);
            CombinedColorChooser.this.reconfigureSlider((Object)this.component);
        }
    }
}

