/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.scriptable.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.extensions.datasources.scriptable.ScriptableDataFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ScriptableDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/scriptable-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.setDefaultNamespace("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable");
        tagDescription.setNamespaceHasCData("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", false);
        tagDescription.setElementHasCData("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "query", true);
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/scriptable");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "scriptable-datasource", rootAttrs, false);
        ScriptableDataFactory scriptableDataFactory = (ScriptableDataFactory)dataFactory;
        AttributeList configAttrs = new AttributeList();
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "language", String.valueOf(scriptableDataFactory.getLanguage()));
        if (!StringUtils.isEmpty((String)scriptableDataFactory.getScript())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "script", String.valueOf(scriptableDataFactory.getScript()));
        }
        if (!StringUtils.isEmpty((String)scriptableDataFactory.getScript())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "shutdown-script", String.valueOf(scriptableDataFactory.getShutdownScript()));
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "config", configAttrs, true);
        String[] queryNames = scriptableDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = scriptableDataFactory.getQuery(queryName);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/scriptable", "query", "name", queryName, false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }
}

