/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.raw;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.raw.RawResourceData;

public class RawResourceLoader
implements ResourceLoader {
    public static final String SCHEMA_NAME = RawResourceLoader.class.getName();

    @Override
    public boolean isSupportedKey(ResourceKey key) {
        return SCHEMA_NAME.equals(key.getSchema());
    }

    @Override
    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        if (!(value instanceof byte[])) {
            return null;
        }
        return new ResourceKey(SCHEMA_NAME, value, factoryKeys);
    }

    @Override
    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (path != null) {
            throw new ResourceKeyCreationException("Unable to derive key for new path.");
        }
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        if (factoryKeys == null) {
            return parent;
        }
        HashMap<ParameterKey, Object> map = new HashMap<ParameterKey, Object>();
        map.putAll(parent.getFactoryParameters());
        map.putAll(factoryKeys);
        return new ResourceKey(parent.getSchema(), parent.getIdentifier(), map);
    }

    @Override
    public URL toURL(ResourceKey key) {
        return null;
    }

    @Override
    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("The key type is not supported.");
        }
        return new RawResourceData(key);
    }

    @Override
    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new NullPointerException("The ResourceKey can not be null");
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        if (!(key.getIdentifier() instanceof byte[])) {
            throw new IllegalArgumentException("ResourceKey is invalid - identifier is not a byte[] object");
        }
        byte[] data = (byte[])key.getIdentifier();
        char[] cdata = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            cdata[i] = (char)(data[i] & 0xFF);
        }
        return ResourceKeyUtils.createStringResourceKey(String.valueOf(key.getSchema()), new String(cdata), key.getFactoryParameters());
    }

    @Override
    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData keyData = ResourceKeyUtils.parse(stringKey);
        if (!SCHEMA_NAME.equals(keyData.getSchema())) {
            throw new ResourceKeyCreationException("Serialized version of key does not contain correct schema");
        }
        String identifier = keyData.getIdentifier();
        char[] chars = identifier.toCharArray();
        byte[] data = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            data[i] = (byte)chars[i];
        }
        return this.createKey(data, keyData.getFactoryParameters());
    }

    @Override
    public boolean isSupportedDeserializer(String data) {
        return SCHEMA_NAME.equals(ResourceKeyUtils.readSchemaFromString(data));
    }
}

