/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.welcome;

import java.io.File;
import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class SampleReport
implements Serializable {
    private String fileName;
    private String reportName;
    private long lastAccessTime;
    private long fileSize;

    public SampleReport(File reportFile, ResourceManager resourceManager) {
        this.lastAccessTime = reportFile.lastModified();
        this.fileSize = reportFile.length();
        this.fileName = reportFile.getAbsolutePath();
        try {
            ResourceKey resourceKey = resourceManager.createKey((Object)reportFile);
            this.reportName = this.computeNameFromMetadata(resourceManager, resourceKey);
            if (StringUtils.isEmpty((String)this.reportName)) {
                this.reportName = this.computeNameFromReport(resourceManager, resourceKey);
            }
        }
        catch (ResourceException re) {
            this.reportName = null;
        }
    }

    private String computeNameFromMetadata(ResourceManager resourceManager, ResourceKey key) {
        try {
            Resource res = resourceManager.create(key, null, new Class[]{DocumentBundle.class});
            DocumentBundle rawResource = (DocumentBundle)res.getResource();
            Object possibleTitle = rawResource.getMetaData().getBundleAttribute("http://purl.org/dc/elements/1.1/", "title");
            if (possibleTitle != null) {
                return possibleTitle.toString();
            }
            return null;
        }
        catch (ResourceException re) {
            return null;
        }
    }

    private String computeNameFromReport(ResourceManager resourceManager, ResourceKey key) {
        try {
            Resource res = resourceManager.create(key, null, new Class[]{MasterReport.class});
            MasterReport rawResource = (MasterReport)res.getResource();
            String possibleTitle = rawResource.getName();
            if (possibleTitle != null) {
                return possibleTitle.toString();
            }
            return null;
        }
        catch (ResourceException re) {
            return null;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getReportName() {
        return this.reportName;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SampleReport)) {
            return false;
        }
        SampleReport that = (SampleReport)o;
        if (this.fileSize != that.fileSize) {
            return false;
        }
        if (this.lastAccessTime != that.lastAccessTime) {
            return false;
        }
        return this.fileName.equals(that.fileName);
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = 31 * result + (int)(this.lastAccessTime ^ this.lastAccessTime >>> 32);
        result = 31 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        return result;
    }
}

