/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.firewall;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.UtilMessages;

public class FirewallingProxySelector
extends ProxySelector {
    private ProxySelector defaultSelector;
    private static final String LOCALHOST = "localhost";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final String LOCALHOST_LOCALDOMAIN = "localhost.localdomain";

    public FirewallingProxySelector(ProxySelector defaultSelector) {
        this.defaultSelector = defaultSelector;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (WorkspaceSettings.getInstance().isOfflineMode()) {
            if (LOCALHOST.equalsIgnoreCase(uri.getHost())) {
                return this.selectDefault(uri);
            }
            if (LOCALHOST_IP.equalsIgnoreCase(uri.getHost())) {
                return this.selectDefault(uri);
            }
            if (LOCALHOST_LOCALDOMAIN.equalsIgnoreCase(uri.getHost())) {
                return this.selectDefault(uri);
            }
            throw new IllegalArgumentException(UtilMessages.getInstance().getString("FirewallingProxySelector.FilterMessage"));
        }
        return this.selectDefault(uri);
    }

    private List<Proxy> selectDefault(URI uri) {
        if (this.defaultSelector != null) {
            return this.defaultSelector.select(uri);
        }
        ArrayList<Proxy> list = new ArrayList<Proxy>();
        list.add(Proxy.NO_PROXY);
        return list;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.defaultSelector.connectFailed(uri, sa, ioe);
    }
}

