/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.status;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.text.StyleContext;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.libraries.designtime.swing.MacOSXIntegration;

public class MemoryStatusGadget
extends JLabel {
    private static final Color BG = SystemColor.textHighlight;
    private double tm;
    private double fm;
    private Timer timer;

    public MemoryStatusGadget() {
        if (MacOSXIntegration.MAC_OS_X) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10), BorderFactory.createLineBorder(SystemColor.controlShadow)));
        } else {
            this.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        }
        this.setFont(StyleContext.getDefaultStyleContext().getFont(this.getFont().getName(), 0, this.getFont().getSize() - 2));
        this.setHorizontalAlignment(0);
        this.timer = new Timer(500, new MemoryStatusUpdateAction());
        this.timer.setRepeats(true);
        this.timer.start();
        this.addMouseListener(new GarbageCollectorAction());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color origColor = g.getColor();
        g.setColor(SystemColor.control);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int w = (int)((double)this.getWidth() * ((this.tm - this.fm) / this.tm));
        g.setColor(BG);
        g.fillRect(0, 0, w, this.getHeight());
        g.setColor(origColor);
        super.paintComponent(g);
    }

    public void dispose() {
        this.timer.stop();
    }

    private class MemoryStatusUpdateAction
    implements ActionListener {
        private MemoryStatusUpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            MemoryStatusGadget.this.tm = (double)totalMemory / 1048576.0;
            MemoryStatusGadget.this.fm = (double)freeMemory / 1048576.0;
            MemoryStatusGadget.this.setText(Messages.getString("MemoryStatusGadget.Text", MemoryStatusGadget.this.tm - MemoryStatusGadget.this.fm, MemoryStatusGadget.this.tm));
        }
    }

    private static class GarbageCollectorAction
    extends MouseAdapter {
        private GarbageCollectorAction() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            System.gc();
        }
    }
}

