/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class RecentFilesModel {
    private EventListenerList eventListeners = new EventListenerList();
    private Preferences properties = Preferences.userRoot().node("org/pentaho/reporting/designer/recent-files");
    private static final File[] EMPTY_FILES = new File[0];

    public void addSettingsListener(SettingsListener listener) {
        this.eventListeners.add(SettingsListener.class, listener);
    }

    public void removeSettingsListener(SettingsListener listener) {
        this.eventListeners.remove(SettingsListener.class, listener);
    }

    public File[] getRecentFiles() {
        try {
            ArrayList<File> retval = this.getFilesAsList();
            return retval.toArray(new File[retval.size()]);
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return EMPTY_FILES;
        }
    }

    private ArrayList<File> getFilesAsList() throws BackingStoreException {
        ArrayList<File> retval = new ArrayList<File>();
        Object[] strings = this.properties.keys();
        Arrays.sort(strings);
        int maxFiles = Math.min(10, strings.length);
        for (int i = 0; i < maxFiles; ++i) {
            Object key = strings[i];
            File file = new File(this.properties.get((String)key, null));
            if (!file.isFile() || !file.canRead()) continue;
            retval.add(file);
        }
        if (retval.size() != strings.length) {
            this.store(retval);
        }
        return retval;
    }

    private void store(List files) throws BackingStoreException {
        this.properties.clear();
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            this.properties.put(String.valueOf(i), file.getAbsolutePath());
        }
        this.properties.flush();
    }

    public void addFile(File file) {
        try {
            ArrayList<File> filesAsList = this.getFilesAsList();
            int idx = filesAsList.indexOf(file);
            if (idx == -1) {
                filesAsList.add(0, file);
                while (filesAsList.size() > 10) {
                    filesAsList.remove(filesAsList.remove(filesAsList.size() - 1));
                }
            } else {
                filesAsList.remove(idx);
                filesAsList.add(0, file);
            }
            this.store(filesAsList);
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        this.fireSettingsChanged();
    }

    private void fireSettingsChanged() {
        SettingsListener[] listeners = (SettingsListener[])this.eventListeners.getListeners(SettingsListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener listener = listeners[i];
            listener.settingsChanged();
        }
    }

    public void clear() {
        try {
            this.properties.clear();
            this.fireSettingsChanged();
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }
}

