/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportStructureTreeModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;

public class TreeSelectionHelper {
    private TreeSelectionHelper() {
    }

    public static TreePath getPathForNode(ReportStructureTreeModel treeModel, Object currentSelection) {
        if (currentSelection instanceof Element) {
            return TreeSelectionHelper.getBasePathForNode((Element)currentSelection, treeModel.getReport());
        }
        if (currentSelection instanceof DataFactory) {
            CompoundDataFactory params = treeModel.getDataFactoryElement();
            if (treeModel.getIndexOfChild(params, currentSelection) < 0) {
                return null;
            }
            return new TreePath(new Object[]{treeModel.getRoot(), params, currentSelection});
        }
        return null;
    }

    private static TreePath getBasePathForNode(Element node, AbstractReportDefinition stopOnReport) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element re = node; re != null; re = re.getParentSection()) {
            list.add(re);
            if (re == stopOnReport) break;
        }
        Object[] data = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportElement element = (ReportElement)list.get(i);
            data[data.length - 1 - i] = element;
        }
        return new TreePath(data);
    }
}

