/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public class ReportFieldNode {
    private DataFactory source;
    private String fieldName;
    private Class fieldClass;
    private ReportDocumentContext context;

    public ReportFieldNode(ReportDocumentContext context, String fieldName, Class fieldClass) {
        this(context, null, fieldName, fieldClass);
    }

    public ReportFieldNode(ReportDocumentContext context, DataFactory source, String fieldName, Class fieldClass) {
        ArgumentNullException.validate((String)"context", (Object)context);
        ArgumentNullException.validate((String)"fieldName", (Object)fieldName);
        ArgumentNullException.validate((String)"fieldClass", (Object)fieldClass);
        this.context = context;
        this.fieldName = fieldName;
        this.fieldClass = fieldClass;
        this.source = source;
    }

    public ContextAwareDataSchemaModel getDataSchemaModel() {
        return this.context.getReportDataSchemaModel();
    }

    public DataFactory getSource() {
        return this.source;
    }

    public String toString() {
        return "ReportFieldNode{source=" + this.source + ", fieldName='" + this.fieldName + '\'' + ", fieldClass=" + this.fieldClass + '}';
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class getFieldClass() {
        return this.fieldClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportFieldNode that = (ReportFieldNode)o;
        if (this.fieldClass != null ? !this.fieldClass.equals(that.fieldClass) : that.fieldClass != null) {
            return false;
        }
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + (this.fieldClass != null ? this.fieldClass.hashCode() : 0);
        return result;
    }
}

