/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.structuretree;

import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pentaho.reporting.designer.core.actions.report.EditParametersAction;
import org.pentaho.reporting.designer.core.actions.report.EditQueryAction;
import org.pentaho.reporting.designer.core.editor.ReportDataChangeListener;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportDataTreeModel;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportTree;
import org.pentaho.reporting.designer.core.editor.structuretree.MasterReportDataTreeModel;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFieldNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.editor.structuretree.StructureTreeCellRenderer;
import org.pentaho.reporting.designer.core.editor.structuretree.SubReportDataTreeModel;
import org.pentaho.reporting.designer.core.editor.structuretree.SubReportParametersNode;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.dnd.FieldDescriptionTransferable;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeExpressionChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleExpressionChange;
import org.pentaho.reporting.engine.classic.core.designtime.SubReportParameterChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class DataReportTree
extends AbstractReportTree {
    private ReportDocumentContext renderContext;
    private ReportUpdateHandler updateHandler = new ReportUpdateHandler();
    private SettingsChangeHandler settingsChangeHandler;

    public DataReportTree() {
        this.setCellRenderer(new StructureTreeCellRenderer());
        this.setTransferHandler(new ColumnTransferHandler());
        this.setDragEnabled(true);
        this.setEditable(false);
        this.setRootVisible(false);
        this.addMouseListener(new EditQueryDoubleClickHandler());
        this.settingsChangeHandler = new SettingsChangeHandler();
        WorkspaceSettings.getInstance().addSettingsListener(this.settingsChangeHandler);
    }

    @Override
    public ReportDocumentContext getRenderContext() {
        return this.renderContext;
    }

    @Override
    protected TreePath getPathForNode(Object node) {
        if (this.getDataTreeModel() == null) {
            return null;
        }
        return this.getDataTreeModel().getPathForNode(node);
    }

    @Override
    public void setRenderContext(ReportDocumentContext renderContext) {
        if (this.renderContext != null) {
            this.renderContext.getSelectionModel().removeReportSelectionListener(this.getSelectionHandler());
            this.renderContext.getReportDefinition().removeReportModelListener((ReportModelListener)this.updateHandler);
            this.renderContext.removeReportDataChangeListener(this.updateHandler);
        }
        this.renderContext = renderContext;
        if (this.renderContext != null) {
            this.renderContext.getSelectionModel().addReportSelectionListener(this.getSelectionHandler());
            this.renderContext.getReportDefinition().addReportModelListener((ReportModelListener)this.updateHandler);
            this.renderContext.addReportDataChangeListener(this.updateHandler);
        }
        this.updateFromRenderContext();
        this.restoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFromRenderContext() {
        try {
            AbstractReportDataTreeModel model;
            this.setUpdateFromExternalSource(true);
            if (this.renderContext == null) {
                this.setModel(EMPTY_MODEL);
                return;
            }
            AbstractReportDefinition report = this.renderContext.getReportDefinition();
            if (report instanceof MasterReport) {
                model = new MasterReportDataTreeModel(this.renderContext);
            } else if (report instanceof SubReport) {
                model = new SubReportDataTreeModel(this.renderContext);
            } else {
                this.setModel(EMPTY_MODEL);
                return;
            }
            this.setModel(model);
            DocumentContextSelectionModel selectionModel = this.renderContext.getSelectionModel();
            Object[] selectedElements = selectionModel.getSelectedElements();
            ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
            for (int i = 0; i < selectedElements.length; ++i) {
                Object o = selectedElements[i];
                TreePath path = model.getPathForNode(o);
                if (path == null) continue;
                selectionPaths.add(path);
            }
            this.getSelectionModel().setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
            SwingUtilities.invokeLater(new ExpandDataFactoryNodesTask(model));
            SwingUtilities.invokeLater(new ExpandExpressionNodesTask(model));
            SwingUtilities.invokeLater(new ExpandParameterDataSourceTask(model));
            SwingUtilities.invokeLater(new ExpandEnvironmentDataSourceTask(model));
        }
        finally {
            this.setUpdateFromExternalSource(false);
        }
    }

    private AbstractReportDataTreeModel getDataTreeModel() {
        TreeModel model = this.getModel();
        if (model instanceof AbstractReportDataTreeModel) {
            return (AbstractReportDataTreeModel)model;
        }
        return null;
    }

    private class EditQueryDoubleClickHandler
    extends MouseAdapter {
        private EditQueryDoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                TreePath selectionPath = DataReportTree.this.getLeadSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                try {
                    Object selection = selectionPath.getLastPathComponent();
                    if (selection instanceof ParameterDefinitionEntry) {
                        ParameterDefinitionEntry parameterDefinitionEntry = (ParameterDefinitionEntry)selection;
                        EditParametersAction.performEditMasterReportParameters(DataReportTree.this.getReportDesignerContext(), parameterDefinitionEntry);
                        return;
                    }
                    if (selection instanceof ParameterMapping || selection instanceof SubReportParametersNode) {
                        EditParametersAction.performEditSubReportParameters(DataReportTree.this.getReportDesignerContext());
                        return;
                    }
                    if (selection instanceof DataFactory) {
                        EditQueryAction action = new EditQueryAction();
                        action.setReportDesignerContext(DataReportTree.this.getReportDesignerContext());
                        action.performEdit((DataFactory)selection, null);
                        return;
                    }
                    if (selection instanceof ReportQueryNode) {
                        ReportQueryNode queryNode = (ReportQueryNode)selection;
                        if (!queryNode.isAllowEdit()) {
                            return;
                        }
                        EditQueryAction action = new EditQueryAction();
                        action.setReportDesignerContext(DataReportTree.this.getReportDesignerContext());
                        action.performEdit(queryNode.getDataFactory(), queryNode.getQueryName());
                        e.consume();
                    }
                }
                catch (ReportDataFactoryException e1) {
                    UncaughtExceptionsModel.getInstance().addException(e1);
                }
            }
        }
    }

    private class ColumnTransferHandler
    extends TransferHandler {
        private ColumnTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Expression expression;
            Object o;
            if (c != DataReportTree.this) {
                return null;
            }
            Object node = DataReportTree.this.getSelectionPath().getLastPathComponent();
            if (node instanceof ReportFieldNode) {
                ReportFieldNode field = (ReportFieldNode)node;
                return new FieldDescriptionTransferable(field.getFieldName());
            }
            if (node instanceof ParameterMapping && (o = DataReportTree.this.getSelectionPath().getParentPath().getLastPathComponent()) instanceof SubReportParametersNode.ImportParametersNode) {
                ParameterMapping field = (ParameterMapping)node;
                return new FieldDescriptionTransferable(field.getAlias());
            }
            if (node instanceof ParameterDefinitionEntry) {
                ParameterDefinitionEntry field = (ParameterDefinitionEntry)node;
                return new FieldDescriptionTransferable(field.getName());
            }
            if (node instanceof Expression && (expression = (Expression)node).getName() != null) {
                return new FieldDescriptionTransferable(expression.getName());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class ExpandEnvironmentDataSourceTask
    implements Runnable {
        private AbstractReportDataTreeModel treeModel;

        private ExpandEnvironmentDataSourceTask(AbstractReportDataTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public void run() {
            if (DataReportTree.this.getModel() != this.treeModel) {
                return;
            }
            DataReportTree.this.expandPath(new TreePath(new Object[]{this.treeModel.getRoot(), this.treeModel.getReportEnvironmentDataRow()}));
        }
    }

    private class ExpandParameterDataSourceTask
    implements Runnable {
        private AbstractReportDataTreeModel treeModel;

        private ExpandParameterDataSourceTask(AbstractReportDataTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public void run() {
            AbstractReportDataTreeModel dataTreeModel;
            if (DataReportTree.this.getModel() != this.treeModel) {
                return;
            }
            if (this.treeModel instanceof MasterReportDataTreeModel) {
                dataTreeModel = (MasterReportDataTreeModel)this.treeModel;
                DataReportTree.this.expandPath(new TreePath(new Object[]{((MasterReportDataTreeModel)dataTreeModel).getRoot(), ((MasterReportDataTreeModel)dataTreeModel).getReportParametersNode()}));
            }
            if (this.treeModel instanceof SubReportDataTreeModel) {
                dataTreeModel = (SubReportDataTreeModel)this.treeModel;
                DataReportTree.this.expandPath(new TreePath(new Object[]{((SubReportDataTreeModel)dataTreeModel).getRoot(), ((SubReportDataTreeModel)dataTreeModel).getReportParametersNode()}));
            }
        }
    }

    private class ExpandExpressionNodesTask
    implements Runnable {
        private AbstractReportDataTreeModel treeModel;

        private ExpandExpressionNodesTask(AbstractReportDataTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public void run() {
            if (DataReportTree.this.getModel() != this.treeModel) {
                return;
            }
            AbstractReportDataTreeModel dataTreeModel = this.treeModel;
            DataReportTree.this.expandPath(new TreePath(new Object[]{dataTreeModel.getRoot(), dataTreeModel.getReportFunctionNode()}));
        }
    }

    private class ExpandDataFactoryNodesTask
    implements Runnable {
        private AbstractReportDataTreeModel treeModel;

        private ExpandDataFactoryNodesTask(AbstractReportDataTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public void run() {
            if (DataReportTree.this.getModel() != this.treeModel) {
                return;
            }
            CompoundDataFactory compoundDataFactory = this.treeModel.getDataFactoryElement();
            int size = compoundDataFactory.size();
            for (int i = 0; i < size; ++i) {
                DataFactory df = compoundDataFactory.getReference(i);
                TreePath path = this.treeModel.getPathForNode(df);
                if (path == null) {
                    return;
                }
                DataReportTree.this.expandPath(path);
                int count = this.treeModel.getChildCount(df);
                for (int x = 0; x < count; ++x) {
                    Object child = this.treeModel.getChild(df, x);
                    if (child == null) continue;
                    TreePath childPath = path.pathByAddingChild(child);
                    DataReportTree.this.expandPath(childPath);
                }
            }
        }
    }

    private class SettingsChangeHandler
    implements SettingsListener {
        private boolean showIndexColumns = WorkspaceSettings.getInstance().isShowIndexColumns();

        private SettingsChangeHandler() {
        }

        @Override
        public void settingsChanged() {
            if (this.showIndexColumns != WorkspaceSettings.getInstance().isShowIndexColumns()) {
                this.showIndexColumns = WorkspaceSettings.getInstance().isShowIndexColumns();
                TreeModel model = DataReportTree.this.getModel();
                if (model instanceof AbstractReportDataTreeModel) {
                    AbstractReportDataTreeModel realModel = (AbstractReportDataTreeModel)model;
                    realModel.fireTreeDataChanged();
                    DataReportTree.this.restoreState();
                }
            }
            DataReportTree.this.invalidateLayoutCache();
        }
    }

    private class ReportUpdateHandler
    implements ReportModelListener,
    ReportDataChangeListener {
        private ReportUpdateHandler() {
        }

        @Override
        public void dataModelChanged(ReportDocumentContext context) {
            AbstractReportDataTreeModel realModel = DataReportTree.this.getDataTreeModel();
            if (realModel == null) {
                return;
            }
            DebugLog.log((Object)"Data Changed, Update tree");
            realModel.fireQueryChanged(DataReportTree.this.renderContext.getReportDefinition().getQuery());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeChanged(ReportModelEvent event) {
            AbstractReportDataTreeModel realModel = DataReportTree.this.getDataTreeModel();
            if (realModel == null) {
                return;
            }
            try {
                if (event.isNodeDeleteEvent()) {
                    this.handleNodeRemoved(event, realModel);
                }
                if (event.isNodeAddedEvent()) {
                    this.handleNodeAdded(event, realModel);
                }
                if (event.getType() == 0) {
                    if (event.getElement() == DataReportTree.this.renderContext.getReportDefinition()) {
                        Object eventParameter = event.getParameter();
                        if (eventParameter instanceof AttributeExpressionChange || eventParameter instanceof StyleChange || eventParameter instanceof StyleExpressionChange) {
                            return;
                        }
                        if (eventParameter instanceof AttributeChange) {
                            AttributeChange attributeChange = (AttributeChange)eventParameter;
                            if ("http://reporting.pentaho.org/namespaces/engine/attributes/internal".equals(attributeChange.getNamespace()) || "query".equals(attributeChange.getName())) {
                                realModel.fireQueryChanged(attributeChange.getOldValue());
                                realModel.fireQueryChanged(attributeChange.getNewValue());
                            }
                            return;
                        }
                        if (eventParameter instanceof Expression || eventParameter instanceof ReportParameterDefinition) {
                            realModel.fireTreeNodeChanged(eventParameter);
                        } else if (eventParameter instanceof SubReportParameterChange) {
                            if (realModel instanceof SubReportDataTreeModel) {
                                SubReportDataTreeModel subReportDataTreeModel = (SubReportDataTreeModel)realModel;
                                realModel.fireTreeStructureChanged(subReportDataTreeModel.getReportParametersNode());
                            }
                        } else {
                            realModel.fireTreeDataChanged();
                        }
                    } else {
                        realModel.fireTreeNodeChanged(event.getElement());
                    }
                }
            }
            finally {
                DataReportTree.this.restoreState();
                this.expandAfterDataSourceEdit(event);
            }
        }

        private void handleNodeRemoved(ReportModelEvent event, AbstractReportDataTreeModel realModel) {
            if (event.getElement() == DataReportTree.this.renderContext.getReportDefinition()) {
                Object eventParam = event.getParameter();
                if (eventParam instanceof Expression) {
                    Expression expression = (Expression)eventParam;
                    realModel.fireExpressionRemoved(expression);
                } else if (eventParam instanceof ParameterDefinitionEntry) {
                    ParameterDefinitionEntry parameter = (ParameterDefinitionEntry)eventParam;
                    if (realModel instanceof MasterReportDataTreeModel) {
                        MasterReportDataTreeModel masterModel = (MasterReportDataTreeModel)realModel;
                        masterModel.fireParameterRemoved(parameter);
                    }
                } else if (eventParam instanceof DataFactory) {
                    realModel.fireTreeStructureChanged(realModel.getDataFactoryElement());
                } else {
                    realModel.fireTreeDataChanged();
                }
            }
        }

        private void handleNodeAdded(ReportModelEvent event, AbstractReportDataTreeModel realModel) {
            if (event.getElement() == DataReportTree.this.renderContext.getReportDefinition()) {
                Object eventParam = event.getParameter();
                if (eventParam instanceof Expression) {
                    Expression expression = (Expression)eventParam;
                    realModel.fireExpressionAdded(expression);
                } else if (eventParam instanceof ParameterDefinitionEntry) {
                    ParameterDefinitionEntry parameter = (ParameterDefinitionEntry)eventParam;
                    if (realModel instanceof MasterReportDataTreeModel) {
                        MasterReportDataTreeModel masterModel = (MasterReportDataTreeModel)realModel;
                        masterModel.fireParameterAdded(parameter);
                    }
                } else if (eventParam instanceof DataFactory) {
                    realModel.fireTreeStructureChanged(realModel.getDataFactoryElement());
                } else {
                    realModel.fireTreeDataChanged();
                }
            }
        }

        private void expandAfterDataSourceEdit(ReportModelEvent event) {
            Object element = event.getElement();
            if (!event.isNodeStructureChanged()) {
                return;
            }
            if (!(element instanceof AbstractReportDefinition)) {
                return;
            }
            if (!(DataReportTree.this.treeModel instanceof AbstractReportDataTreeModel)) {
                return;
            }
            AbstractReportDataTreeModel dataTreeModel = (AbstractReportDataTreeModel)DataReportTree.this.treeModel;
            Object parameter = event.getParameter();
            if (parameter instanceof DataFactory) {
                SwingUtilities.invokeLater(new ExpandDataFactoryNodesTask(dataTreeModel));
            } else if (parameter instanceof Expression) {
                SwingUtilities.invokeLater(new ExpandExpressionNodesTask(dataTreeModel));
            } else if (parameter instanceof ReportParameterDefinition) {
                SwingUtilities.invokeLater(new ExpandParameterDataSourceTask(dataTreeModel));
            }
        }
    }
}

