/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.pentaho.reporting.designer.core.editor.parameters.InstantEditingTable;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class DefaultValueEditorPanel
extends JPanel {
    private ElementMetaDataTable editor;
    private SingleValueMetaTableModel singleValueMetaTableModel = new SingleValueMetaTableModel();

    public DefaultValueEditorPanel() {
        this.editor = new InstantEditingTable();
        this.editor.setDefaultRenderer(Boolean.class, (TableCellRenderer)new GenericCellRenderer());
        this.editor.setDefaultEditor(Boolean.class, new DefaultCellEditor(new JComboBox<Object>(new Object[]{null, Boolean.TRUE, Boolean.FALSE})));
        this.editor.setModel(this.singleValueMetaTableModel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.editor, "Center");
        this.installDefaults();
    }

    protected void installDefaults() {
        Border b;
        Color fg;
        Color bg;
        Font f = this.editor.getFont();
        if (f == null || f instanceof UIResource) {
            this.editor.setFont(UIManager.getFont("TextField.font"));
        }
        if ((bg = this.editor.getBackground()) == null || bg instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor("TextField.background"));
            this.editor.setSelectionBackground(UIManager.getColor("TextField.background"));
        }
        if ((fg = this.editor.getForeground()) == null || fg instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor("TextField.foreground"));
            this.editor.setSelectionForeground(UIManager.getColor("TextField.foreground"));
        }
        if ((b = this.editor.getBorder()) == null || b instanceof UIResource) {
            Insets insets = UIManager.getInsets("TextField.margin");
            if (insets == null) {
                this.editor.setBorder(UIManager.getBorder("TextField.border"));
            } else {
                this.editor.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(insets), UIManager.getBorder("TextField.border")));
            }
            this.editor.setRowMargin(2);
            this.editor.setRowHeight(20);
        }
        this.editor.setShowGrid(false);
        this.editor.setShowHorizontalLines(false);
        this.editor.setShowVerticalLines(false);
    }

    public Object getValue() {
        TableCellEditor editor1 = this.editor.getCellEditor();
        if (editor1 != null) {
            editor1.stopCellEditing();
        }
        return this.singleValueMetaTableModel.getValue();
    }

    public void setValue(Object value, Class valueType) {
        this.singleValueMetaTableModel.setValue(value, valueType);
    }

    public void setValueType(Class valueType, String pattern, TimeZone timeZone) {
        Object value = this.singleValueMetaTableModel.getValue();
        if (valueType.isArray() == this.singleValueMetaTableModel.getValueType().isArray()) {
            try {
                String oldValueAsString = ConverterRegistry.toAttributeValue((Object)value);
                Object oldValueConverted = ConverterRegistry.toPropertyValue((String)oldValueAsString, (Class)valueType);
                this.singleValueMetaTableModel.setValue(oldValueConverted, valueType);
            }
            catch (BeanException e) {
                this.singleValueMetaTableModel.setValue(null, valueType);
            }
        } else if (valueType.isArray()) {
            try {
                Object array = Array.newInstance(this.singleValueMetaTableModel.getValueType(), 1);
                Array.set(array, 0, value);
                String oldValueAsString = ConverterRegistry.toAttributeValue((Object)array);
                Object oldValueConverted = ConverterRegistry.toPropertyValue((String)oldValueAsString, (Class)valueType);
                this.singleValueMetaTableModel.setValue(oldValueConverted, valueType);
            }
            catch (BeanException e) {
                this.singleValueMetaTableModel.setValue(null, valueType);
            }
        } else {
            try {
                String oldValueAsString = ConverterRegistry.toAttributeValue((Object)Array.get(value, 0));
                Object oldValueConverted = ConverterRegistry.toPropertyValue((String)oldValueAsString, (Class)valueType);
                this.singleValueMetaTableModel.setValue(oldValueConverted, valueType);
            }
            catch (Exception e) {
                this.singleValueMetaTableModel.setValue(null, valueType);
            }
        }
        this.editor.applyLocaleSettings(new InjectDatePatternLocaleSettings(valueType, pattern, timeZone));
    }

    private static class SingleValueMetaTableModel
    extends AbstractTableModel
    implements ElementMetaDataTableModel {
        private Object value;
        private Class valueType = Object.class;
        private static final String[] EMPTY_EXTRA_FIELDS = new String[0];

        private SingleValueMetaTableModel() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value, Class valueType) {
            if (valueType == null) {
                throw new NullPointerException();
            }
            this.value = value;
            this.valueType = valueType;
            this.fireTableStructureChanged();
        }

        public Class getValueType() {
            return this.valueType;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int columnIndex) {
            return this.valueType;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.value;
        }

        @Override
        public String[] getExtraFields(int row, int column) {
            return EMPTY_EXTRA_FIELDS;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.value = aValue;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public Class getClassForCell(int row, int column) {
            return this.valueType;
        }

        public PropertyEditor getEditorForCell(int row, int column) {
            if (String.class.equals((Object)this.valueType)) {
                return null;
            }
            return FastPropertyEditorManager.findEditor(this.valueType);
        }

        @Override
        public String getValueRole(int row, int column) {
            return "Value";
        }

        @Override
        public void setTableStyle(TableStyle tableStyle) {
        }

        @Override
        public TableStyle getTableStyle() {
            return TableStyle.ASCENDING;
        }
    }

    private static class InjectDatePatternLocaleSettings
    implements LocaleSettings {
        private Class type;
        private String pattern;
        private TimeZone timeZone;

        private InjectDatePatternLocaleSettings(Class type, String pattern, TimeZone timeZone) {
            this.type = type;
            this.pattern = pattern;
            this.timeZone = timeZone;
        }

        public String getDateFormatPattern() {
            if (!StringUtils.isEmpty((String)this.pattern) && Date.class.equals((Object)this.type)) {
                return this.pattern;
            }
            return WorkspaceSettings.getInstance().getDateFormatPattern();
        }

        public String getTimeFormatPattern() {
            if (!StringUtils.isEmpty((String)this.pattern) && Time.class.equals((Object)this.type)) {
                return this.pattern;
            }
            return WorkspaceSettings.getInstance().getTimeFormatPattern();
        }

        public String getDatetimeFormatPattern() {
            if (!StringUtils.isEmpty((String)this.pattern) && java.util.Date.class.equals((Object)this.type)) {
                return this.pattern;
            }
            if (!StringUtils.isEmpty((String)this.pattern) && Timestamp.class.equals((Object)this.type)) {
                return this.pattern;
            }
            return WorkspaceSettings.getInstance().getDatetimeFormatPattern();
        }

        public Locale getLocale() {
            return WorkspaceSettings.getInstance().getLocale();
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }
    }
}

