/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.groups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.groups.EditGroupDetailsDialog;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntry;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class GroupDataEntryCellEditor
extends JPanel
implements TableCellEditor {
    private static final String POPUP_EDITOR = "popupEditor";
    private JTextField textField;
    private JButton ellipsisButton;
    private EventListenerList eventListenerList;
    private ReportDocumentContext reportContext;
    private GroupDataEntry groupDataEntry;

    public GroupDataEntryCellEditor() {
        this.setLayout(new BorderLayout());
        this.eventListenerList = new EventListenerList();
        this.ellipsisButton = new JButton("...");
        this.ellipsisButton.setDefaultCapable(false);
        this.ellipsisButton.setMargin(new Insets(0, 0, 0, 0));
        this.ellipsisButton.addActionListener(new ExtendedEditorAction());
        this.textField = new JTextField();
        this.textField.setDocument(new NonFilteringPlainDocument());
        this.textField.getInputMap().put(Messages.getOptionalKeyStroke("AbstractStringValueCellEditor.Popup.Accelerator"), POPUP_EDITOR);
        this.textField.getActionMap().put(POPUP_EDITOR, new ExtendedEditorAction());
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setEditable(false);
        this.add((Component)this.textField, "Center");
        this.add((Component)this.ellipsisButton, "East");
    }

    protected GroupDataEntry getGroupDataEntry() {
        return this.groupDataEntry;
    }

    protected void setGroupDataEntry(GroupDataEntry groupDataEntry) {
        this.groupDataEntry = groupDataEntry;
        if (groupDataEntry == null) {
            this.textField.setText("");
            this.ellipsisButton.setEnabled(false);
        } else {
            this.textField.setText(this.groupDataEntry.getFieldsAsText());
            this.ellipsisButton.setEnabled(true);
        }
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    @Override
    public Object getCellEditorValue() {
        return this.groupDataEntry;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.fireEditingStopped();
            this.textField.setText(null);
            return true;
        }
        catch (Exception e) {
            this.fireEditingCanceled();
            this.textField.setText(null);
            return true;
        }
    }

    @Override
    public void cancelCellEditing() {
        this.textField.setText(null);
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!(value instanceof GroupDataEntry)) {
            this.setGroupDataEntry(null);
            this.textField.setText(null);
        } else {
            this.setGroupDataEntry((GroupDataEntry)value);
        }
        return this;
    }

    public ReportDocumentContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(ReportDocumentContext reportContext) {
        this.reportContext = reportContext;
    }

    private class ExtendedEditorAction
    extends AbstractAction {
        private ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupDataEntry value = GroupDataEntryCellEditor.this.getGroupDataEntry();
            if (value == null) {
                return;
            }
            Window window = LibSwingUtil.getWindowAncestor((Component)GroupDataEntryCellEditor.this);
            EditGroupDetailsDialog editorDialog = window instanceof Frame ? new EditGroupDetailsDialog((Frame)window) : (window instanceof Dialog ? new EditGroupDetailsDialog((Dialog)window) : new EditGroupDetailsDialog());
            if (editorDialog.editGroupData(value.getName(), value.getFields(), GroupDataEntryCellEditor.this.getReportContext())) {
                GroupDataEntryCellEditor.this.setGroupDataEntry(new GroupDataEntry(value.getInstanceID(), editorDialog.getGroupName(), editorDialog.getFields()));
            }
            GroupDataEntryCellEditor.this.stopCellEditing();
        }
    }

    private static class NonFilteringPlainDocument
    implements Document {
        private PlainDocument backend = new PlainDocument();

        private NonFilteringPlainDocument() {
        }

        @Override
        public int getLength() {
            return this.backend.getLength();
        }

        @Override
        public void addDocumentListener(DocumentListener listener) {
            this.backend.addDocumentListener(listener);
        }

        @Override
        public void removeDocumentListener(DocumentListener listener) {
            this.backend.removeDocumentListener(listener);
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            this.backend.addUndoableEditListener(listener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            this.backend.removeUndoableEditListener(listener);
        }

        @Override
        public Object getProperty(Object key) {
            return this.backend.getProperty(key);
        }

        @Override
        public void putProperty(Object key, Object value) {
            if ("filterNewlines".equals(key)) {
                return;
            }
            this.backend.putProperty(key, value);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            this.backend.remove(offs, len);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            this.backend.insertString(offset, str, a);
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return this.backend.getText(offset, length);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            this.backend.getText(offset, length, txt);
        }

        @Override
        public Position getStartPosition() {
            return this.backend.getStartPosition();
        }

        @Override
        public Position getEndPosition() {
            return this.backend.getEndPosition();
        }

        @Override
        public Position createPosition(int offs) throws BadLocationException {
            return this.backend.createPosition(offs);
        }

        @Override
        public Element[] getRootElements() {
            return this.backend.getRootElements();
        }

        @Override
        public Element getDefaultRootElement() {
            return this.backend.getDefaultRootElement();
        }

        @Override
        public void render(Runnable r) {
            this.backend.render(r);
        }
    }
}

