/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DrillDownParameterTableModel
extends AbstractTableModel
implements ElementMetaDataTableModel,
GroupingModel {
    private static final Log logger = LogFactory.getLog(DrillDownParameterTableModel.class);
    private static final DrillDownParameter[] EMPTY_ELEMENTS = new DrillDownParameter[0];
    private static final GroupingHeader[] EMPTY_GROUPINGS = new GroupingHeader[0];
    private HashSet filteredParameterNames;
    private String[] filteredParameterNamesArray = new String[0];
    private GroupingHeader[] groupings;
    private TableStyle tableStyle;
    private DrillDownParameter[] elements;
    private DrillDownParameter[] groupedElements;
    private String[] extraFields;

    public DrillDownParameterTableModel() {
        this.filteredParameterNames = new HashSet();
        this.tableStyle = TableStyle.GROUPED;
        this.elements = EMPTY_ELEMENTS;
        this.groupings = EMPTY_GROUPINGS;
        this.groupedElements = EMPTY_ELEMENTS;
        this.extraFields = new String[0];
    }

    public String[] getExtraFields() {
        return (String[])this.extraFields.clone();
    }

    public void setExtraFields(String[] extraFields) {
        this.extraFields = (String[])extraFields.clone();
    }

    @Override
    public int getRowCount() {
        return this.groupedElements.length;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        return "Value";
    }

    @Override
    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        if (tableStyle == null) {
            throw new NullPointerException();
        }
        this.tableStyle = tableStyle;
        this.updateData(this.getData());
    }

    private DrillDownParameter[] filter(DrillDownParameter[] elements) {
        ArrayList<DrillDownParameter> retval = new ArrayList<DrillDownParameter>(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            DrillDownParameter element = elements[i];
            if (this.filteredParameterNames.contains(element.getName())) continue;
            retval.add(element);
        }
        return retval.toArray(new DrillDownParameter[retval.size()]);
    }

    protected void updateData(DrillDownParameter[] elements) {
        this.elements = (DrillDownParameter[])elements.clone();
        DrillDownParameter[] metaData = this.filter(elements);
        if (this.tableStyle == TableStyle.ASCENDING) {
            Arrays.sort(metaData, new PlainParameterComparator());
            this.groupings = new GroupingHeader[metaData.length];
            this.groupedElements = metaData;
        } else if (this.tableStyle == TableStyle.DESCENDING) {
            Arrays.sort(metaData, Collections.reverseOrder(new PlainParameterComparator()));
            this.groupings = new GroupingHeader[metaData.length];
            this.groupedElements = metaData;
        } else {
            Arrays.sort(metaData, new GroupedParameterComparator());
            int groupCount = 0;
            if (metaData.length > 0) {
                DrillDownParameter.Type oldValue = null;
                for (int i = 0; i < metaData.length; ++i) {
                    if (groupCount == 0) {
                        groupCount = 1;
                        DrillDownParameter firstdata = metaData[i];
                        oldValue = firstdata.getType();
                        continue;
                    }
                    DrillDownParameter data = metaData[i];
                    DrillDownParameter.Type grouping = data.getType();
                    if (ObjectUtilities.equal((Object)((Object)oldValue), (Object)((Object)grouping))) continue;
                    oldValue = grouping;
                    ++groupCount;
                }
            }
            DrillDownParameter[] groupedMetaData = new DrillDownParameter[metaData.length + groupCount];
            this.groupings = new GroupingHeader[groupedMetaData.length];
            int targetIdx = 0;
            GroupingHeader group = null;
            for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
                DrillDownParameter data = metaData[sourceIdx];
                if (sourceIdx == 0) {
                    this.groupings[targetIdx] = group = new GroupingHeader(data.getType().toString());
                    ++targetIdx;
                } else {
                    String newgroup = data.getType().toString();
                    if (!ObjectUtilities.equal((Object)newgroup, (Object)group.getHeaderText())) {
                        this.groupings[targetIdx] = group = new GroupingHeader(newgroup);
                        ++targetIdx;
                    }
                }
                this.groupings[targetIdx] = group;
                groupedMetaData[targetIdx] = data;
                ++targetIdx;
            }
            this.groupedElements = groupedMetaData;
        }
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DrillDownParameter metaData = this.groupedElements[rowIndex];
        if (metaData == null) {
            return this.groupings[rowIndex];
        }
        switch (columnIndex) {
            case 0: {
                return new GroupedName(metaData, metaData.getName(), metaData.getType().toString());
            }
            case 1: {
                return metaData.getFormulaFragment();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DrillDownParameter metaData = this.groupedElements[rowIndex];
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return metaData.getType() == DrillDownParameter.Type.MANUAL;
            }
            case 1: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DrillDownParameter metaData = this.groupedElements[rowIndex];
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                if (aValue instanceof GroupedName) {
                    GroupedName name = (GroupedName)aValue;
                    metaData.setName(name.getName());
                    this.fireTableDataChanged();
                }
                return;
            }
            case 1: {
                if (aValue == null) {
                    metaData.setFormulaFragment(null);
                } else {
                    metaData.setFormulaFragment(String.valueOf(aValue));
                }
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Class getClassForCell(int row, int column) {
        DrillDownParameter metaData = this.groupedElements[row];
        if (metaData == null) {
            return GroupingHeader.class;
        }
        if (column == 0) {
            return GroupedName.class;
        }
        return String.class;
    }

    public PropertyEditor getEditorForCell(int row, int column) {
        return null;
    }

    @Override
    public String getValueRole(int row, int column) {
        if (column == 0) {
            return "Value";
        }
        return "Formula";
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        return this.extraFields;
    }

    @Override
    public GroupingHeader getGroupHeader(int index) {
        return this.groupings[index];
    }

    @Override
    public boolean isHeaderRow(int index) {
        return this.groupedElements[index] == null;
    }

    public String[] getFilteredParameterNames() {
        return (String[])this.filteredParameterNamesArray.clone();
    }

    public void setFilteredParameterNames(String[] names) {
        this.filteredParameterNamesArray = (String[])names.clone();
        this.filteredParameterNames.clear();
        this.filteredParameterNames.addAll(Arrays.asList(names));
        this.updateData(this.elements);
    }

    public void setData(DrillDownParameter[] parameter) {
        this.updateData(parameter);
    }

    public DrillDownParameter[] getData() {
        return (DrillDownParameter[])this.elements.clone();
    }

    public DrillDownParameter[] getGroupedData() {
        return (DrillDownParameter[])this.groupedElements.clone();
    }

    public DrillDownParameter.Type getParameterType(int row) {
        DrillDownParameter downParameter = this.groupedElements[row];
        if (downParameter != null) {
            return downParameter.getType();
        }
        return null;
    }

    public boolean isPreferred(int row) {
        DrillDownParameter downParameter = this.groupedElements[row];
        if (downParameter != null) {
            return downParameter.isPreferred();
        }
        return true;
    }

    private static class GroupedParameterComparator
    implements Comparator {
        private GroupedParameterComparator() {
        }

        public int compare(Object o1, Object o2) {
            DrillDownParameter.Type type2;
            DrillDownParameter parameter1 = (DrillDownParameter)o1;
            DrillDownParameter parameter2 = (DrillDownParameter)o2;
            if (parameter1 == null && parameter2 == null) {
                return 0;
            }
            if (parameter1 == null) {
                return -1;
            }
            if (parameter2 == null) {
                return 1;
            }
            DrillDownParameter.Type type1 = parameter1.getType();
            int compareType = type1.compareTo(type2 = parameter2.getType());
            if (compareType != 0) {
                return compareType;
            }
            if (parameter1.getPosition() < parameter2.getPosition()) {
                return -1;
            }
            if (parameter1.getPosition() > parameter2.getPosition()) {
                return 1;
            }
            return parameter1.getName().compareTo(parameter2.getName());
        }
    }

    private static class PlainParameterComparator
    implements Comparator {
        private PlainParameterComparator() {
        }

        public int compare(Object o1, Object o2) {
            DrillDownParameter parameter1 = (DrillDownParameter)o1;
            DrillDownParameter parameter2 = (DrillDownParameter)o2;
            if (parameter1 == null && parameter2 == null) {
                return 0;
            }
            if (parameter1 == null) {
                return -1;
            }
            if (parameter2 == null) {
                return 1;
            }
            if (parameter1.getPosition() < parameter2.getPosition()) {
                return -1;
            }
            if (parameter1.getPosition() > parameter2.getPosition()) {
                return 1;
            }
            return parameter1.getName().compareTo(parameter2.getName());
        }
    }
}

