/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.ReportDesignerView;
import org.pentaho.reporting.designer.core.actions.global.PasteAction;
import org.pentaho.reporting.designer.core.actions.report.AddDataFactoryAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFunctionNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportParametersNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportQueryNode;
import org.pentaho.reporting.designer.core.editor.structuretree.SubReportParametersNode;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ContextMenuUtility {
    private ContextMenuUtility() {
    }

    public static JPopupMenu getMenu(ReportDesignerContext context, Object selectedElement) {
        ReportRenderContext doc;
        ReportDesignerView view = context.getView();
        if (selectedElement == null || selectedElement instanceof MasterReport) {
            return view.getPopupMenu("popup-ReportDefinition");
        }
        ReportDocumentContext activeContext = context.getActiveContext();
        if (activeContext instanceof ReportRenderContext && selectedElement == (doc = (ReportRenderContext)activeContext).getReportDefinition()) {
            if (selectedElement instanceof CrosstabElement) {
                return view.getPopupMenu("popup-CrosstabElement");
            }
            return view.getPopupMenu("popup-ReportDefinition");
        }
        if (selectedElement instanceof SubReport) {
            return view.getPopupMenu("popup-SubReport");
        }
        if (selectedElement instanceof CompoundDataFactory) {
            return ContextMenuUtility.createDataSourcePopup(context);
        }
        if (selectedElement instanceof DataFactory) {
            return view.getPopupMenu("popup-DataSource");
        }
        if (selectedElement instanceof ReportFunctionNode) {
            return view.getPopupMenu("popup-Expressions");
        }
        if (selectedElement instanceof ReportQueryNode) {
            ReportQueryNode rqn = (ReportQueryNode)selectedElement;
            if (rqn.isAllowEdit()) {
                return view.getPopupMenu("popup-Query");
            }
            return view.getPopupMenu("popup-Inherited-Query");
        }
        if (selectedElement instanceof Expression) {
            return view.getPopupMenu("popup-Expression");
        }
        if (selectedElement instanceof RootLevelBand) {
            return view.getPopupMenu("popup-RootLevelBand");
        }
        if (selectedElement instanceof RelationalGroup) {
            return view.getPopupMenu("popup-RelationalGroup");
        }
        if (selectedElement instanceof CrosstabGroup) {
            return view.getPopupMenu("popup-CrosstabGroup");
        }
        if (selectedElement instanceof CrosstabOtherGroup) {
            return view.getPopupMenu("popup-CrosstabOtherGroup");
        }
        if (selectedElement instanceof CrosstabRowGroup) {
            return view.getPopupMenu("popup-CrosstabRowGroup");
        }
        if (selectedElement instanceof CrosstabColumnGroup) {
            return view.getPopupMenu("popup-CrosstabColumnGroup");
        }
        if (selectedElement instanceof CrosstabCellBody) {
            return view.getPopupMenu("popup-CrosstabCellBody");
        }
        if (selectedElement instanceof Group) {
            return view.getPopupMenu("popup-Group");
        }
        if (selectedElement instanceof Band) {
            return view.getPopupMenu("popup-Band");
        }
        if (selectedElement instanceof Element) {
            Element element = (Element)selectedElement;
            JPopupMenu popup = view.getPopupMenu("popup-" + element.getElementTypeName());
            if (popup != null) {
                return popup;
            }
            return view.getPopupMenu("popup-Element");
        }
        if (selectedElement instanceof ReportParameterDefinition) {
            return view.getPopupMenu("popup-Parameters");
        }
        if (selectedElement instanceof ParameterDefinitionEntry) {
            return view.getPopupMenu("popup-Parameter");
        }
        if (selectedElement instanceof ReportParametersNode) {
            return view.getPopupMenu("popup-Parameters");
        }
        if (selectedElement instanceof SubReportParametersNode) {
            return view.getPopupMenu("popup-SubReportParameters");
        }
        return null;
    }

    public static JPopupMenu createDataSourcePopup(ReportDesignerContext designerContext) {
        JPopupMenu insertDataSourcesMenu = new JPopupMenu();
        PasteAction action = new PasteAction();
        action.setReportDesignerContext(designerContext);
        insertDataSourcesMenu.add(action);
        insertDataSourcesMenu.addSeparator();
        ContextMenuUtility.createDataSourceMenu(designerContext, insertDataSourcesMenu);
        return insertDataSourcesMenu;
    }

    public static void createDataSourceMenu(ReportDesignerContext designerContext, JComponent insertDataSourcesMenu) {
        JMenu subMenu = null;
        HashMap<String, Boolean> groupingMap = new HashMap<String, Boolean>();
        DataFactoryMetaData[] datas = DataFactoryRegistry.getInstance().getAll();
        for (int i = 0; i < datas.length; ++i) {
            DataFactoryMetaData data = datas[i];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data) || !data.isEditorAvailable()) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            groupingMap.put(currentGrouping, groupingMap.containsKey(currentGrouping));
        }
        Arrays.sort(datas, new GroupedMetaDataComparator());
        String grouping = null;
        boolean firstElement = true;
        for (int i = 0; i < datas.length; ++i) {
            DataFactoryMetaData data = datas[i];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data) || !data.isEditorAvailable()) continue;
            String currentGrouping = data.getGrouping(Locale.getDefault());
            boolean isMultiGrouping = (Boolean)groupingMap.get(currentGrouping);
            if (!firstElement) {
                if (!ObjectUtilities.equal((Object)currentGrouping, grouping)) {
                    grouping = currentGrouping;
                    if (isMultiGrouping) {
                        subMenu = new JMenu(currentGrouping);
                        insertDataSourcesMenu.add(subMenu);
                    }
                }
            } else {
                firstElement = false;
                grouping = currentGrouping;
                if (isMultiGrouping) {
                    subMenu = new JMenu(currentGrouping);
                    insertDataSourcesMenu.add(subMenu);
                }
            }
            AddDataFactoryAction action = new AddDataFactoryAction(data);
            action.setReportDesignerContext(designerContext);
            if (isMultiGrouping) {
                subMenu.add(new JMenuItem(action));
                continue;
            }
            insertDataSourcesMenu.add(new JMenuItem(action));
        }
    }
}

