/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report.preview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewParametersDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public final class PreviewTextAction
extends AbstractReportContextAction {
    public PreviewTextAction() {
        this.putValue("Name", ActionMessages.getString("PreviewTextAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("PreviewTextAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PreviewTextAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PreviewTextAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getActiveContext() == null) {
            return;
        }
        MasterReport reportElement = (MasterReport)this.getActiveContext().getContextRoot();
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        if (PreviewParametersDialog.process((Window)window, (MasterReport)reportElement)) {
            ReportProgressDialog dialog = window instanceof JDialog ? new ReportProgressDialog((Dialog)((JDialog)window)) : (window instanceof JFrame ? new ReportProgressDialog((Frame)((JFrame)window)) : new ReportProgressDialog());
            Thread t = new Thread(new ExportTask(reportElement, dialog));
            t.setDaemon(true);
            t.start();
        }
    }

    private static class ExportTask
    implements Runnable {
        private MasterReport report;
        private ReportProgressDialog progressDialog;

        private ExportTask(MasterReport report, ReportProgressDialog progressDialog) {
            this.report = report;
            this.progressDialog = progressDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File tempFile = File.createTempFile("report-designer-preview", ".txt");
                tempFile.deleteOnExit();
                FileOutputStream fout = new FileOutputStream(tempFile);
                try {
                    BufferedOutputStream bout = new BufferedOutputStream(fout);
                    float charPerInch = ParserUtil.parseFloat((String)this.report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch"), (float)10.0f);
                    float linesPerInch = ParserUtil.parseFloat((String)this.report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch"), (float)6.0f);
                    PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor((PrinterDriver)new TextFilePrinterDriver((OutputStream)bout, charPerInch, linesPerInch), this.report.getConfiguration());
                    PageableReportProcessor reportProcessor = new PageableReportProcessor(this.report, (PageableOutputProcessor)outputProcessor);
                    reportProcessor.addReportProgressListener((ReportProgressListener)this.progressDialog);
                    this.progressDialog.setVisibleInEDT(true);
                    reportProcessor.processReport();
                    reportProcessor.close();
                    bout.flush();
                    reportProcessor.removeReportProgressListener((ReportProgressListener)this.progressDialog);
                }
                finally {
                    fout.close();
                }
                this.progressDialog.setVisibleInEDT(false);
                ExternalToolLauncher.openURL(tempFile.toURI().toURL().toExternalForm());
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
                this.progressDialog.dispose();
                String errorMessage = ActionMessages.getString("PreviewReport.Error.Text", new Object[0]);
                String errorTitle = ActionMessages.getString("PreviewReport.Error.Title", new Object[0]);
                ExceptionDialog.showExceptionDialog((Component)this.progressDialog.getParent(), (String)errorTitle, (String)errorMessage, (Exception)e1);
            }
        }
    }
}

