/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.AlignmentOptionsDialog;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.DefaultGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.GuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PageSetupDialog;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class PageSetupAction
extends AbstractReportContextAction {
    public PageSetupAction() {
        this.putValue("Name", ActionMessages.getString("PageSetupAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("PageSetupAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PageSetupAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PageSetupAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        MasterReport report = (MasterReport)activeContext.getContextRoot();
        PageDefinition originalPageDef = report.getPageDefinition();
        if ("true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.print.UseAlternatePageSetupDialog"))) {
            DefaultGuiContext context = new DefaultGuiContext();
            Window proxy = LibSwingUtil.getWindowAncestor((Component)this.getReportDesignerContext().getView().getParent());
            PageSetupDialog dialog = proxy instanceof Frame ? new PageSetupDialog((GuiContext)context, (Frame)proxy) : (proxy instanceof Dialog ? new PageSetupDialog((GuiContext)context, (Dialog)proxy) : new PageSetupDialog((GuiContext)context));
            PageDefinition definition = dialog.performSetup(originalPageDef);
            if (!dialog.isConfirmed()) {
                return;
            }
            if (ObjectUtilities.equal((Object)definition, (Object)originalPageDef)) {
                return;
            }
            report.setPageDefinition(definition);
        } else {
            PageFormat original;
            PrinterJob pj = PrinterJob.getPrinterJob();
            PageFormat pf = pj.validatePage(pj.pageDialog(original = originalPageDef.getPageFormat(0)));
            if (PageFormatFactory.isEqual((PageFormat)pf, (PageFormat)original)) {
                return;
            }
            PageDefinition pageDefinition = report.getPageDefinition();
            if (pageDefinition instanceof SimplePageDefinition) {
                SimplePageDefinition spd = (SimplePageDefinition)pageDefinition;
                report.setPageDefinition((PageDefinition)new SimplePageDefinition(pf, spd.getPageCountHorizontal(), spd.getPageCountVertical()));
            } else {
                report.setPageDefinition((PageDefinition)new SimplePageDefinition(pf));
            }
        }
        this.alignElements(originalPageDef);
    }

    private void alignElements(PageDefinition original) {
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        AlignmentOptionsDialog dialog = window instanceof JDialog ? new AlignmentOptionsDialog((JDialog)window, this.getActiveContext(), original) : (window instanceof JFrame ? new AlignmentOptionsDialog((JFrame)window, this.getActiveContext(), original) : new AlignmentOptionsDialog(this.getActiveContext(), original));
        dialog.performEdit();
    }
}

