/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.report.SaveReportUtilities;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.status.ExceptionDialog;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractSaveReportAction
extends AbstractReportContextAction {
    protected abstract void init();

    protected abstract File getTarget(MasterReport var1, Component var2);

    public AbstractSaveReportAction() {
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        this.saveReport(this.getReportDesignerContext(), activeContext, this.getReportDesignerContext().getView().getParent());
    }

    public boolean saveReport(ReportDesignerContext context, ReportDocumentContext activeContext, Component parent) {
        MasterReport report = (MasterReport)activeContext.getContextRoot();
        File target = this.getTarget(report, parent);
        if (target == null) {
            return false;
        }
        try {
            report.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path", (Object)target.getCanonicalPath());
        }
        catch (IOException ioe) {
            report.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "report-save-path", (Object)target.getAbsolutePath());
        }
        if (SaveReportUtilities.saveReport(context, activeContext, target)) {
            try {
                ResourceManager resourceManager = report.getResourceManager();
                Resource bundleResource = resourceManager.createDirectly((Object)target, DocumentBundle.class);
                DocumentBundle bundle = (DocumentBundle)bundleResource.getResource();
                ResourceKey bundleKey = bundle.getBundleKey();
                report.setDefinitionSource(bundleKey);
                report.setContentBase(bundleKey);
                report.setResourceManager(bundle.getResourceManager());
                activeContext.resetChangeTracker();
            }
            catch (ResourceException e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
            return true;
        }
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ExceptionDialog exceptionDialog = window instanceof Dialog ? new ExceptionDialog((Dialog)window) : (window instanceof Frame ? new ExceptionDialog((Frame)window) : new ExceptionDialog());
        exceptionDialog.showDialog();
        return false;
    }
}

